/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.ConsolidatedHistoryItems;
import com.atlassian.crucible.actions.HistoryItem;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.actions.ReviewStateEvent;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.util.CsvWriter;
import com.google.common.base.Strings;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

public class ReviewHistoryAction
extends ReviewBaseAction
implements ServletResponseAware {
    private final List<ConsolidatedHistoryItems> events = new ArrayList<ConsolidatedHistoryItems>();
    private final List<ReviewStateEvent> reviewStates = new ArrayList<ReviewStateEvent>();
    private final CrucibleUserManager userManager = SpringContext.getComponent(CrucibleUserManager.class, "crucibleUserManager");
    private String content;
    private HttpServletResponse response;

    @RequireSecurityToken(value=false)
    public String doDetails() throws Exception {
        this.calculateHistoryItems(ConsolidatedHistoryItems.TimePeriod.MINUTE, true);
        return "success";
    }

    @RequireSecurityToken(value=false)
    public String doVisualisation() {
        this.calculateHistoryItems(ConsolidatedHistoryItems.TimePeriod.HOUR, false);
        this.calculateReviewStates();
        return "success";
    }

    @RequireSecurityToken(value=false)
    public String doWrapper() {
        if (Strings.isNullOrEmpty((String)this.content)) {
            this.content = this.getUserPreferences().getReviewHistoryTab();
        }
        return "success";
    }

    @RequireSecurityToken(value=false)
    public String doCSV() throws IOException {
        this.calculateHistoryItems(ConsolidatedHistoryItems.TimePeriod.MINUTE, true);
        this.response.setContentType("text/csv");
        this.response.addHeader("Content-Disposition", "filename=" + this.getPermaId() + ".csv;attachment");
        CsvWriter writer = new CsvWriter(this.response.getWriter());
        writer.writeHeaderColumn("Date");
        writer.writeHeaderColumn("User");
        writer.writeHeaderColumn("Action");
        writer.writeHeaderColumn("Details");
        writer.writeHeaderColumn("Entity ID");
        writer.writeHeaderColumn("Old value");
        writer.writeHeaderColumn("New value");
        writer.endHeader();
        for (LogItem event : this.getLogItems()) {
            writer.writeDate(event.getCreateDateTime());
            FecruUser user = this.getUser(event);
            writer.writeString(user == null ? "" : user.getUsername());
            String action = event.getLogAction() == LogAction.EXTERNAL ? (Object)((Object)LogAction.EXTERNAL) + ":" + event.getEntityString() : event.getAction();
            writer.writeString(action);
            writer.writeString(event.getDescription());
            writer.writeInt(event.getEntityId());
            writer.writeString(event.getOldValue());
            writer.writeString(event.getNewValue());
            writer.endRow();
        }
        this.response.getWriter().close();
        return "success";
    }

    private void calculateHistoryItems(ConsolidatedHistoryItems.TimePeriod timePeriod, boolean preserveOrder) {
        LinkedList<ConsolidatedHistoryItems> openItems = new LinkedList<ConsolidatedHistoryItems>();
        for (LogItem item : this.getLogItems()) {
            ConsolidatedHistoryItems consolidatingItem = this.getConsolidatingItem(item, openItems);
            HistoryItem historyItem = new HistoryItem(item, this.userManager);
            if (consolidatingItem != null) {
                consolidatingItem.add(historyItem);
                continue;
            }
            consolidatingItem = new ConsolidatedHistoryItems(historyItem, timePeriod);
            this.events.add(consolidatingItem);
            if (preserveOrder) {
                openItems.clear();
            }
            if (consolidatingItem.getLogAction() == null || !consolidatingItem.getLogAction().supportsConsolidation()) continue;
            openItems.add(consolidatingItem);
        }
    }

    private FecruUser getUser(LogItem item) {
        return CrucibleUserManager.getUserById(item.getUserId());
    }

    private List<LogItem> getLogItems() {
        return LogManager.getLogForReview(this.getReview().getId());
    }

    private ConsolidatedHistoryItems getConsolidatingItem(LogItem item, List<ConsolidatedHistoryItems> openItems) {
        Iterator<ConsolidatedHistoryItems> openItemIterator = openItems.iterator();
        while (openItemIterator.hasNext()) {
            ConsolidatedHistoryItems openItem = openItemIterator.next();
            if (item.getCreateDateTime() > openItem.getEndDate()) {
                openItemIterator.remove();
                continue;
            }
            if (!openItem.canConsolidate(item)) continue;
            return openItem;
        }
        return null;
    }

    private void calculateReviewStates() {
        List<StateChangeLog> stateChanges = LogManager.getStateChanges(this.getReviewid(), false);
        for (int i2 = 0; i2 < stateChanges.size() - 1; ++i2) {
            StateChangeLog thisState = stateChanges.get(i2);
            StateChangeLog nextState = stateChanges.get(i2 + 1);
            this.reviewStates.add(new ReviewStateEvent(thisState.getNewState(), thisState.getDateTimeStamp(), nextState.getDateTimeStamp()));
        }
        StateChangeLog lastStateChange = stateChanges.get(stateChanges.size() - 1);
        State state = StateManager.INSTANCE.getStateByName(lastStateChange.getNewState());
        if (state.isDraftMetaState() || state.isOpenMetaState()) {
            this.reviewStates.add(new ReviewStateEvent(lastStateChange.getNewState(), lastStateChange.getDateTimeStamp(), System.currentTimeMillis()));
        }
    }

    public String getFirstEventDate() {
        if (this.events.size() > 0) {
            return this.events.get(0).getDate().toString();
        }
        return new Date().toString();
    }

    public Long getFirstEventDateLong() {
        if (this.events.size() > 0) {
            return this.events.get(0).getDate().getTime();
        }
        return System.currentTimeMillis();
    }

    public List<ConsolidatedHistoryItems> getEvents() {
        return this.events;
    }

    public List<ReviewStateEvent> getReviewStates() {
        return this.reviewStates;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean getTimeline() {
        return "timeline".equals(this.content);
    }

    @Override
    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public long getReviewDuration() {
        if (this.reviewStates.size() == 0) {
            return 0L;
        }
        long timeStart = this.reviewStates.get(0).getTimeStart();
        long timeEnd = this.reviewStates.get(this.reviewStates.size() - 1).getTimeEnd();
        return (timeEnd - timeStart) / 60000L;
    }
}

