/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.PagedSearch;
import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.fecru.analytics.AnalyticsEvent;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.view.ReviewRowDetail;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterState;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterTree;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;

public class ReviewDashboardAction
extends PagedSearch {
    protected ReviewFilterState filterState;
    protected ReviewFilterTree filterTree;
    @Resource
    protected GlobalPermissionService globalPermissionService;

    @RequireSecurityToken(value=false)
    public String execute() {
        this.getFilterState().setFilterFromSession();
        this.eventPublisher.publish((Object)new AnalyticsEvent("cru.view.review.dashboard"));
        return "success";
    }

    private ReviewFilterState getFilterState() {
        if (this.filterState == null) {
            this.filterState = new ReviewFilterState(this.getCurrentUser(), ReviewFilters.FilterKey.INBOX, ((Object)((Object)this)).getClass().getSimpleName());
        }
        return this.filterState;
    }

    private ReviewFilterTree getFilterTree() {
        if (this.filterTree == null) {
            this.filterTree = new ReviewFilterTree(this.getFilterState());
        }
        return this.filterTree;
    }

    public String getSort() {
        return this.getFilterState().getSort();
    }

    public void setSort(String sort) {
        this.getFilterState().setSort(sort);
    }

    public String getOrder() {
        return this.getFilterState().getOrder();
    }

    public void setOrder(String order) {
        this.getFilterState().setOrder(order);
    }

    public String[] getState() {
        return this.getFilterState().getState();
    }

    public void setState(String[] state) {
        this.getFilterState().setState(state);
    }

    public String getAuthor() {
        return this.getFilterState().getAuthor();
    }

    public void setAuthor(String author) {
        this.getFilterState().setAuthor(author);
    }

    public String getModerator() {
        return this.getFilterState().getModerator();
    }

    public void setModerator(String moderator) {
        this.getFilterState().setModerator(moderator);
    }

    public String getCreator() {
        return this.getFilterState().getCreator();
    }

    public void setCreator(String creator) {
        this.getFilterState().setCreator(creator);
    }

    public String getReviewer() {
        return this.getFilterState().getReviewer();
    }

    public void setReviewer(String reviewer) {
        this.getFilterState().setReviewer(reviewer);
    }

    public String getTitle() {
        return this.getFilterState().getTitle();
    }

    public void setTitle(String title) {
        this.getFilterState().setTitle(title);
    }

    public boolean getOrRoles() {
        return this.getFilterState().getOrRoles();
    }

    public void setOrRoles(boolean orRoles) {
        this.getFilterState().setOrRoles(orRoles);
    }

    public String getComplete() {
        return this.getFilterState().getComplete();
    }

    public void setComplete(String complete) {
        this.getFilterState().setComplete(complete);
    }

    public String getFilterName() {
        return this.getFilterState().getFilterName();
    }

    public String getFilterDescription() {
        return this.getFilterState().getFilterDescription();
    }

    public void setFilter(String filter) {
        this.getFilterState().setFilter(filter);
    }

    public String getFilter() {
        return this.getFilterState().getFilter().id;
    }

    public String getProjectKey() {
        Project project = this.filterState.getProject();
        return project == null ? null : project.getProjKey();
    }

    @Override
    public Project getProject() {
        return this.getFilterState().getProject();
    }

    public void setProject(String projectKey) {
        this.getFilterState().setProject(this.projectManager.getProjectByKey(projectKey));
    }

    public List<Project> getProjects() {
        return this.getProjectList();
    }

    public Collection getStates() {
        return this.getFilterState().getStates();
    }

    public Collection<Review.ReviewType> getReviewTypes() {
        return Arrays.asList(Review.ReviewType.values());
    }

    public Review.ReviewType getReviewType() {
        return this.getFilterState().getReviewType();
    }

    public void setReviewType(int reviewTypeId) {
        this.getFilterState().setReviewType(Review.ReviewType.byId(reviewTypeId));
    }

    @Override
    public String getFilterParams() {
        return this.getFilterState().getFilterParams();
    }

    @Override
    public TotalCountAwarePagingCalculator constructPagingCalculator(int page) {
        return TotalCountAwarePagingCalculator.getPagingCalculator(page, this.getFilterState().getNumberOfResults(), 50);
    }

    public List<ReviewRowDetail> getFilteredReviewDetails() {
        return this.getFilterState().getFilteredReviewDetails(this.effectiveUserProvider.getEffectivePrincipal(), this);
    }

    public boolean isSomeResultsHidden() {
        if (this.getFilterState().getFilter().equals((Object)ReviewFilters.FilterKey.CUSTOM)) {
            return false;
        }
        return this.getPagingCalculator().getNumItems() != this.getFilterState().countFilteredReviews(this.getFilterState().getFilter());
    }

    public ReviewFilterTree getReviewFilterTree() {
        return this.getFilterTree();
    }

    public boolean isSnippetOnlyFilter() {
        return Review.ReviewType.SNIPPET.equals((Object)this.getFilterState().getReviewType());
    }

    public boolean isCrucibleUser() {
        return this.getCurrentUser() != null && this.globalPermissionService.hasUserPermissions(this.getCurrentUser().getUsername(), GlobalPermissionType.CRUCIBLE_USER);
    }
}

