/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.crucible.configuration.metrics.MetricsConfig;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.activityitem.ActivityItemData;
import com.atlassian.fecru.activityitem.ActivityItemDataService;
import com.atlassian.fecru.activityitem.ActivityItemSearchCriteria;
import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.RemoteJiraException;
import com.atlassian.fisheye.jira.issue.JiraIssueService;
import com.atlassian.fisheye.jira.issue.QueryContext;
import com.atlassian.fisheye.jira.issue.QueryContextImpl;
import com.atlassian.fisheye.jira.issue.RemoteExceptionHandler;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.CustomFieldList;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.discussion.CommentOperator;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.util.Wrapper;
import com.cenqua.crucible.util.WrappingIterator;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.crucible.view.FRXNavList;
import com.cenqua.crucible.view.ParticipantStats;
import com.cenqua.crucible.view.PatchListDO;
import com.cenqua.crucible.view.ReviewDO;
import com.cenqua.crucible.view.ReviewsToDo;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ReviewBaseAction
extends BaseAction {
    public static final int TODO_PANEL_NUM_REVIEWS = 10;
    private Review review;
    private String permaKeyProject;
    private int permaKeyNumber;
    private MetricsConfig metricsConfig;
    private List<Patch> reviewPatches;
    private List<CrucibleRevision> uploadedCruRevs;
    private ReviewsToDo reviewsTodo;
    private Map<FileRevisionExtraInfo, FRXDO> frxDOs = new HashMap<FileRevisionExtraInfo, FRXDO>();
    private ReviewDO reviewDO;
    @Resource(name="contentManager")
    private ContentManager contentManager;
    @Resource(name="eventPublisher")
    protected EventPublisher eventPublisher;
    @Autowired
    protected JiraIssueService jiraIssueService;
    @Autowired
    private JiraServerService jiraServerService;
    @Autowired
    protected CommentManager commentManager;
    @Autowired
    protected CurrentUserPermissions currentUserPermissions;
    @Autowired
    protected PatchManager patchManager;
    @Autowired
    private ActivityItemDataService activityItemDataService;
    private boolean errorConnectingToJira = false;
    private ReviewParticipant participant;
    private static final String P_RESOLUTION = "resolution";
    private QueryContext queryContext;
    private FRXNavList navList;
    private List<FileRevisionExtraInfo> sortedFrxs;
    private List<Comment> myDraftComments = null;
    private int otherDraftComments = -1;

    public List<Comment> getCommentsWithUnresolvedSubtasks() {
        final ArrayList<Comment> commentsWithUnresolvedSubtasks = new ArrayList<Comment>();
        this.commentManager.comments(this.getReview()).where(DiscussionClauses.visibleToAll()).prune().visit(new CommentOperator(){

            @Override
            public void operate(Comment comment) {
                String issueKey = comment.getJiraIssueKey();
                if (!(ReviewBaseAction.this.errorConnectingToJira || StringUtils.isEmpty((String)issueKey) || ReviewBaseAction.this.isResolvedOrUnreachable(issueKey))) {
                    commentsWithUnresolvedSubtasks.add(comment);
                }
            }
        });
        return commentsWithUnresolvedSubtasks;
    }

    private boolean isResolvedOrUnreachable(String issueKey) {
        JiraIssue issue = this.jiraIssueService.getJiraIssue(issueKey, this.getQueryContext(), new RemoteExceptionHandler(){

            @Override
            public void acceptCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException cre) {
            }

            @Override
            public void acceptException(JiraServer jiraServer, Exception e2) {
                ReviewBaseAction.this.errorConnectingToJira = true;
            }
        });
        return issue == null || issue.getResolution() != null;
    }

    public boolean hasCommentsWithUnresolvedSubtasks() throws IOException, CredentialsRequiredException, RemoteJiraException {
        boolean atLeastOneUnresolved = false;
        for (Comment comment : this.commentManager.comments(this.getReview()).where(DiscussionClauses.and(DiscussionClauses.not(DiscussionClauses.deleted()), DiscussionClauses.hasJira(), new DiscussionClause[0])).collect()) {
            if (this.isResolvedOrUnreachable(comment.getJiraIssueKey())) continue;
            atLeastOneUnresolved = true;
            break;
        }
        return atLeastOneUnresolved;
    }

    public boolean isErrorConnectingToJiraServer() {
        return this.errorConnectingToJira;
    }

    public Review getReview() {
        if (this.review == null && !StringUtils.isEmpty((String)this.permaKeyProject)) {
            this.setReview(this.reviewManager.getReviewByPermaId(new PermaIdKey(this.permaKeyProject, this.permaKeyNumber)));
        }
        return this.review;
    }

    public ReviewDO getReviewDO() {
        if (this.reviewDO == null) {
            this.reviewDO = new ReviewDO(this.getReview(), this.getPrincipal(), this.currentUserPermissions, this.jiraIssueService);
        }
        return this.reviewDO;
    }

    @Override
    public Project getProject() {
        return this.getReview() != null ? this.getReview().getProject() : null;
    }

    public String getRepoName() {
        if (this.getReview() != null) {
            return this.getReview().getDefaultSource() != null ? this.getReview().getDefaultSource() : this.getReview().getProject().getDefaultRepositoryName();
        }
        return "";
    }

    protected ContentManager getContentManager() {
        return this.contentManager;
    }

    public void setReviewid(Integer id) {
        this.setReview(this.reviewManager.getReviewById(id));
    }

    public Integer getReviewid() {
        if (this.review != null) {
            return this.review.getId();
        }
        return null;
    }

    public String getPermaKeyProject() {
        return this.permaKeyProject;
    }

    public void setPermaKeyProject(String permaKeyProject) {
        this.permaKeyProject = Project.upperCaseProjectKey(permaKeyProject);
    }

    public int getPermaKeyNumber() {
        return this.permaKeyNumber;
    }

    public void setPermaKeyNumber(int permaKeyNumber) {
        this.permaKeyNumber = permaKeyNumber;
    }

    @VisibleForTesting
    protected void setReview(Review review) {
        this.review = review;
    }

    public String getPermaId() {
        if (this.review != null) {
            return this.review.getPermaId();
        }
        return null;
    }

    protected QueryContext getQueryContext() {
        if (this.queryContext == null) {
            QueryContextImpl.Builder builder = QueryContextImpl.Builder.newInstance(this.jiraServerService).project(this.getProject());
            this.queryContext = builder.build();
        }
        return this.queryContext;
    }

    protected JiraIssue resolveSubtask(JiraIssue subtask) throws CredentialsRequiredException, IOException, RemoteJiraException {
        if (!subtask.isSubTask()) {
            throw new IllegalStateException(String.format("%s is not a subtask", subtask.getKey()));
        }
        JiraServer.SubtaskConfiguration subtaskConfiguration = (JiraServer.SubtaskConfiguration)Preconditions.checkNotNull((Object)subtask.getJiraServer().getSubtaskConfiguration(), (Object)"Your JIRA Application Link is not configured for subtask creation.");
        int operationId = subtaskConfiguration.getSubtaskResolutionActionId().intValue();
        ArrayListMultimap params = ArrayListMultimap.create();
        params.put((Object)P_RESOLUTION, (Object)Long.toString(subtaskConfiguration.getSubtaskResolutionId()));
        subtask.transitionIssue(operationId, (ListMultimap<String, String>)params);
        return subtask;
    }

    public Iterator<FRXDO> getEmptyFRXs() {
        List<FileRevisionExtraInfo> frxs = this.getSortedFrxs();
        frxs.removeAll(Collections.singleton(null));
        return new WrappingIterator<FileRevisionExtraInfo, FRXDO>(frxs.iterator(), new FRXWrapper(false));
    }

    private Iterator<FRXDO> getUnsortedEmptyFRXs() {
        return new WrappingIterator<FileRevisionExtraInfo, FRXDO>(this.getReview().getFrxs().iterator(), new FRXWrapper(false));
    }

    protected List<FileRevisionExtraInfo> getSortedFrxs() {
        if (this.sortedFrxs == null) {
            this.sortedFrxs = FRXManager.filterNodesForFrxs(this.getFrxNavList().getNavList());
        }
        return this.sortedFrxs;
    }

    public FRXNavList getFrxNavList() {
        if (this.navList == null) {
            this.navList = new FRXNavList(this.getUnsortedEmptyFRXs(), this.sourceFactory, this.getPrincipal());
        }
        return this.navList;
    }

    public ReviewParticipant getParticipant() {
        if (this.participant == null) {
            this.participant = this.getReview().getParticipant(this.getCurrentUser());
        }
        return this.participant;
    }

    public int getIncompleteFileFrxCount() {
        ReviewParticipant participant = this.getParticipant();
        if (participant == null) {
            return 0;
        }
        HashSet<FileRevisionExtraInfo> incompleteFrxs = new HashSet<FileRevisionExtraInfo>();
        incompleteFrxs.addAll(this.getReview().getFrxs());
        incompleteFrxs.removeAll(participant.getCompletedFrxs());
        int incompleteCount = 0;
        for (FileRevisionExtraInfo incompleteFrx : incompleteFrxs) {
            if (incompleteFrx.isDir()) continue;
            ++incompleteCount;
        }
        return incompleteCount;
    }

    public MetricsConfig getMetricsConfig() {
        Integer metricsVersion;
        if (this.metricsConfig == null && (metricsVersion = this.getReview().getMetricsVersion()) != null) {
            this.metricsConfig = MetricsManager.INSTANCE.getConfig(metricsVersion);
        }
        return this.metricsConfig;
    }

    protected void addFields(CustomFieldList dest, Map<String, FieldDefinition> fields) {
        dest.clearFields();
        for (FieldDefinition fd : fields.values()) {
            String val = this.getParameter(fd.getName());
            if (StringUtils.isEmpty((String)val)) continue;
            dest.addField(fd.makeCustomField(val));
        }
    }

    public Collection<FieldDefinition> getCommentFields() {
        MetricsConfig mc = this.getMetricsConfig();
        return mc != null && mc.isValid() ? mc.getCommentFields().values() : new HashSet<FieldDefinition>();
    }

    public Collection<FieldDefinition> getReviewFields() {
        MetricsConfig mc = this.getMetricsConfig();
        return mc != null && mc.isValid() ? mc.getReviewFields().values() : new HashSet<FieldDefinition>();
    }

    public List getStates() {
        return Collections.unmodifiableList(StateManager.INSTANCE.getStates());
    }

    public boolean isWritable() {
        return this.getReview().checkWriteAccess(this.getCurrentUser());
    }

    public boolean isCommentingAllowed() {
        return this.currentUserPermissions.canCommentReview(this.review);
    }

    public boolean isReviewer() throws DbException {
        return this.getReview().isReviewer(this.getCurrentUser());
    }

    public boolean isActiveReviewer() throws DbException {
        return this.getReview().isUncompletedParticipant(this.getCurrentUser());
    }

    public boolean isCompletedReviewer() throws DbException {
        return this.getReview().isCompletedParticipant(this.getCurrentUser());
    }

    public boolean isAuthor() throws DbException {
        return this.getReview().isAuthor(this.getCurrentUser());
    }

    public boolean isModerator() throws DbException {
        return this.getReview().isModerator(this.getCurrentUser());
    }

    public boolean isFileModifiable() {
        return !this.getReview().getState().isClosedMetaState() && this.canModFiles();
    }

    public boolean canSummarize() {
        return this.getReview().getState().getStateType() == StateManager.States.SUMMARIZE_STATE && ReviewUtil.canDoReviewAction(UserActionManager.ACTION_SUMMARIZE, this.getReview());
    }

    protected boolean canModFiles() {
        return this.permissionManager.canEffectivePrincipalDoReviewAction(this.getReview(), UserActionManager.Action.ACTION_MOD_FILES);
    }

    public boolean isCreator() throws DbException {
        return this.getReview().isCreator(this.getCurrentUser());
    }

    public boolean isReviewsComplete() {
        return this.getReview().getCountActiveReviewers() == 0;
    }

    public boolean isClosed() {
        return this.getReview().getState().isClosedState();
    }

    public List<Comment> getViewableComments() {
        ArrayList<Comment> vc = new ArrayList<Comment>();
        for (Comment comment : this.getReview().getComments()) {
            if (!comment.isVisible(this.getCurrentUser())) continue;
            vc.add(comment);
        }
        return vc;
    }

    public List<FRXComment> getFrxComments() {
        ArrayList<FRXComment> fcs = new ArrayList<FRXComment>();
        for (FRXComment fc : this.commentManager.getFrxComments(this.getReview())) {
            if (!fc.isVisible(this.getCurrentUser())) continue;
            fcs.add(fc);
        }
        return fcs;
    }

    public List<Comment> getMyDraftComments() {
        if (this.myDraftComments == null) {
            this.myDraftComments = Collections.unmodifiableList(this.commentManager.comments(this.getReview()).where(DiscussionClauses.and(DiscussionClauses.draft(this.getCurrentUser()), DiscussionClauses.not(DiscussionClauses.deleted()), new DiscussionClause[0])).collect());
        }
        return this.myDraftComments;
    }

    public int getMyDraftCommentCount() {
        return this.getMyDraftComments().size();
    }

    public int getOtherDraftCommentCount() {
        if (this.otherDraftComments == -1) {
            this.otherDraftComments = this.commentManager.comments(this.getReview()).where(DiscussionClauses.and(DiscussionClauses.draft(), DiscussionClauses.not(DiscussionClauses.deleted()), DiscussionClauses.not(DiscussionClauses.author(this.getCurrentUser())))).count();
        }
        return this.otherDraftComments;
    }

    public HashMap getParticipantStats() {
        return new ParticipantStats(this.getReview()).getParticipantStats();
    }

    public boolean isSideBySide() {
        return this.getUserPreferences().isSideBySide();
    }

    public boolean isSoftWrap() {
        return this.getUserPreferences().isSoftWrap();
    }

    public FRXDO makeFRXDO(FileRevisionExtraInfo frx, boolean allowContentFetch) {
        FRXDO frxDO = this.frxDOs.get(frx);
        if (frxDO == null) {
            String keywordOpts = null;
            frxDO = this.getContentManager().makeFRXDO(frx, this.getCurrentUser(), this.getPrincipal(), this.currentUserPermissions, keywordOpts, this.isSideBySide(), this.isSoftWrap(), allowContentFetch);
            this.frxDOs.put(frx, frxDO);
        }
        return frxDO;
    }

    public List<Patch> getPatches() {
        if (this.reviewPatches == null) {
            this.reviewPatches = this.patchManager.findReviewPatches(this.getReview());
        }
        return this.reviewPatches;
    }

    public PatchListDO getPatchDOs() {
        return new PatchListDO(this.getPatches(), this.getPrincipal(), this.sourceFactory);
    }

    public List<CrucibleRevision> getUploadFiles() {
        if (this.uploadedCruRevs == null) {
            this.uploadedCruRevs = FileRevisionManager.getRevisions("UPLOAD:" + this.getReview().getId());
        }
        return this.uploadedCruRevs;
    }

    public TimeZone getTimeZoneForAction() {
        return this.effectiveUserProvider.getEffectiveTimezone();
    }

    public Iterable<ActivityItemData> getAllActivityItems() {
        return this.activityItemDataService.listIterable(ActivityItemSearchCriteria.create(this.review.getPermaId()));
    }

    public ReviewsToDo getReviewsToDo() {
        if (this.reviewsTodo == null) {
            this.reviewsTodo = ReviewsToDo.forCurrentUser(this.effectiveUserProvider, this.currentUserPermissions, this.reviewManager, 10);
        }
        return this.reviewsTodo;
    }

    protected boolean hasJiraLinkPermission() {
        return this.canModFiles();
    }

    public boolean getHasSeenSnippetRewrite() {
        return Boolean.TRUE.equals(this.getAttribute("snippet-rewrite-pass"));
    }

    public CurrentUserPermissions getCurrentUserPermissions() {
        return this.currentUserPermissions;
    }

    public class FRXWrapper
    implements Wrapper<FileRevisionExtraInfo, FRXDO> {
        private final boolean allowContentFetch;

        public FRXWrapper(boolean allowContentFetch) {
            this.allowContentFetch = allowContentFetch;
        }

        @Override
        public FRXDO wrap(FileRevisionExtraInfo frx) {
            return ReviewBaseAction.this.makeFRXDO(frx, this.allowContentFetch);
        }
    }
}

