/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.fecru.actions.analytics.ApproximateCount;
import com.atlassian.fecru.actions.analytics.ReviewPageOpenedEvent;
import com.atlassian.fecru.actions.analytics.SnippetPageOpenedEvent;
import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fisheye.user.RecentlyVisitedManager;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.SnippetManager;
import com.cenqua.crucible.util.PatchAnchorHelper;
import com.cenqua.crucible.view.ReviewDO;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;

public class ReviewAction
extends ReviewBaseAction {
    private static final String VIEW_SNIPPET = "snippet";
    private static final String SNIPPET_REDIRECT = "redirectToSnippet";
    @Autowired
    private RootConfig rootConfig;
    @Autowired
    private SnippetManager snippetManager;
    @Autowired
    private RecentlyVisitedManager recentlyVisitedManager;
    @Autowired
    private UserRepositoryPropertyManager userRepositoryPropertyManager;
    private boolean preview = false;
    private String command;
    private Map<String, String> syntaxes = null;
    private String synhi = null;

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        Review review = this.getReview();
        boolean isSnippet = review.isSnippet();
        if (isSnippet && !this.getHasSeenSnippetRewrite()) {
            return SNIPPET_REDIRECT;
        }
        State state = review.getState();
        if (state.isDraftMetaState() && (this.isModerator() || this.isAuthor() || this.isCreator())) {
            if (this.command == null) {
                this.preview = true;
            } else {
                return this.command;
            }
        }
        if (isSnippet) {
            this.synhi = this.snippetManager.getSnippetRevision(review).getSnippetSyntax();
        } else {
            new PatchAnchorHelper().ensurePatchesValidated(this.sourceFactory, this.getContentManager(), this.getPatches(), this.getPrincipal());
        }
        if (!this.isAnon()) {
            RecentlyVisitedItem.Type type = isSnippet ? RecentlyVisitedItem.Type.SNIPPET : RecentlyVisitedItem.Type.REVIEW;
            this.recentlyVisitedManager.addItemToHistory(type, this.getCurrentUser(), this.getPermaId());
            this.recentlyVisitedManager.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, this.getCurrentUser(), this.getProject().getProjKey());
        }
        this.publishAnalyticsEvent(isSnippet);
        if (isSnippet) {
            return VIEW_SNIPPET;
        }
        return "success";
    }

    private void publishAnalyticsEvent(boolean isSnippet) {
        if (isSnippet) {
            this.eventPublisher.publish((Object)new SnippetPageOpenedEvent());
        } else {
            ReviewDO reviewData = this.getReviewDO();
            int totalCommentCount = reviewData.getCommentTotalCount();
            int unreadCommentCount = reviewData.getTotalUnreadCount();
            int frxCount = this.getSortedFrxs().size();
            this.eventPublisher.publish((Object)new ReviewPageOpenedEvent(ApproximateCount.fromInt(totalCommentCount), reviewData.isCommentable() ? ApproximateCount.fromInt(unreadCommentCount) : ApproximateCount.UNKNOWN, ApproximateCount.fromInt(frxCount), this.effectiveUserProvider.isAnonymous(), this.getParticipant() != null));
        }
    }

    public boolean isSummarize() {
        return this.getReview().getState().isSummarizeState() && this.canSummarize();
    }

    public boolean isPreview() {
        return this.preview;
    }

    public boolean isAnon() {
        return Principal.Anonymous.isAnon((Principal)this.getPrincipal());
    }

    public String getDueDateString() {
        Date dueDate = this.getReview().getDueDate();
        return dueDate == null ? null : ISO8601DateHelper.toIsoDate(dueDate);
    }

    public String getSnippetSyntax() {
        return this.synhi;
    }

    public Map<String, String> getSyntaxes() {
        if (this.syntaxes == null) {
            this.syntaxes = new TreeMap<String, String>();
            this.syntaxes.putAll(this.rootConfig.getSyntaxDefinitions().getSyntaxTypes());
        }
        return this.syntaxes;
    }
}

