/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FRXCommentManager;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.model.managers.InlineCommentManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.view.CommentDO;
import com.cenqua.crucible.view.FRXCommentDO;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.crucible.view.InlineCommentDetailDO;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.filters.TotalityFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class RetrieveCommentsAjaxAction
extends ReviewBaseAction
implements AjaxResponse {
    @Resource
    private UnreadManager unreadManager;
    @Autowired
    protected CommentManager commentManager;
    private final List<Integer> reviewCommentsToRetrieve = new ArrayList<Integer>();
    private final List<Integer> fileCommentsToRetrieve = new ArrayList<Integer>();
    private final List<Integer> inlineCommentsToRetrieve = new ArrayList<Integer>();
    private final Set<CommentDO> updatedReviewComments = new HashSet<CommentDO>();
    private final Set<FRXCommentDO> updatedFileComments = new HashSet<FRXCommentDO>();
    private final Set<InlineCommentDetailDO> updatedInlineComments = new HashSet<InlineCommentDetailDO>();
    private Map<Integer, Pair<Integer, Integer>> frxSliderRevisions = new HashMap<Integer, Pair<Integer, Integer>>();
    private Integer[] frxIds;
    private Integer[] frxFromRevs;
    private Integer[] frxToRevs;

    public void setFrxIds(Integer[] frxIds) {
        this.frxIds = frxIds;
    }

    public void setFrxFromRevs(Integer[] frxFromRevs) {
        this.frxFromRevs = frxFromRevs;
    }

    public void setFrxToRevs(Integer[] frxToRevs) {
        this.frxToRevs = frxToRevs;
    }

    private void initFrxData() {
        if (this.frxIds == null) {
            this.frxIds = new Integer[0];
        }
        for (int i2 = 0; i2 < this.frxIds.length; ++i2) {
            this.frxSliderRevisions.put(this.frxIds[i2], Pair.newInstance(this.frxFromRevs[i2], this.frxToRevs[i2]));
        }
    }

    public void setReviewCommentsToRetrieve(Integer[] reviewCommentsToRetrieve) {
        this.reviewCommentsToRetrieve.addAll(Arrays.asList(reviewCommentsToRetrieve));
    }

    public void setFileCommentsToRetrieve(Integer[] fileCommentsToRetrieve) {
        this.fileCommentsToRetrieve.addAll(Arrays.asList(fileCommentsToRetrieve));
    }

    public void setInlineCommentsToRetrieve(Integer[] inlineCommentsToRetrieve) {
        this.inlineCommentsToRetrieve.addAll(Arrays.asList(inlineCommentsToRetrieve));
    }

    public Set<FRXCommentDO> getUpdatedFileComments() {
        return this.updatedFileComments;
    }

    public Set<CommentDO> getUpdatedReviewComments() {
        return this.updatedReviewComments;
    }

    public Set<InlineCommentDetailDO> getUpdatedInlineComments() {
        return this.updatedInlineComments;
    }

    @Override
    public String getErrorMsg() {
        return "";
    }

    @Override
    public boolean isWorked() {
        return true;
    }

    private boolean isFrxInPage(Integer id) {
        Pair<Integer, Integer> sliderRevs = this.frxSliderRevisions.get(id);
        return sliderRevs != null;
    }

    public void generateComments() {
        FRXRevisionManager frxRevisionManager = new FRXRevisionManager();
        FecruUser currentUser = this.getCurrentUser();
        List<Comment> comments = this.getReview().getCommentsAndReplies();
        for (Comment comment : comments) {
            if (comment.isDeleted() || !this.reviewCommentsToRetrieve.contains(comment.getId())) continue;
            this.updatedReviewComments.add(new CommentDO(this.unreadManager, comment.getRootComment(), currentUser, this.getPrincipal(), this.currentUserPermissions));
        }
        for (Integer commentId : this.fileCommentsToRetrieve) {
            Comment comment;
            FRXComment frxComment = FRXCommentManager.getById(commentId);
            if (frxComment == null && (comment = this.commentManager.getById(commentId)) != null && !comment.isDeleted()) {
                frxComment = comment.getRootComment().getFrxComment();
            }
            if (frxComment == null || frxComment.isDeleted()) continue;
            this.updatedFileComments.add(new FRXCommentDO(this.unreadManager, currentUser, this.getPrincipal(), this.currentUserPermissions, frxComment));
        }
        if (this.inlineCommentsToRetrieve.size() > 0) {
            this.initFrxData();
            HashMap<FileRevisionExtraInfo, HashSet<InlineComment>> frxsToRetrieve = new HashMap<FileRevisionExtraInfo, HashSet<InlineComment>>();
            for (Integer commentId : this.inlineCommentsToRetrieve) {
                Comment comment;
                InlineComment inlineComment = InlineCommentManager.getInlineCommentById(commentId);
                if (inlineComment == null && (comment = this.commentManager.getById(commentId)) != null && !comment.isDeleted()) {
                    inlineComment = comment.getRootComment().getInlineComment();
                }
                if (inlineComment == null || inlineComment.isDeleted() || !this.isFrxInPage(inlineComment.getFrx().getId()) || inlineComment.getFrx() != null && !this.isFrxInPage(inlineComment.getFrx().getId())) continue;
                HashSet<InlineComment> inlineComments = (HashSet<InlineComment>)frxsToRetrieve.get(inlineComment.getFrx());
                if (inlineComments == null) {
                    inlineComments = new HashSet<InlineComment>();
                }
                inlineComments.add(inlineComment);
                frxsToRetrieve.put(inlineComment.getFrx(), inlineComments);
            }
            for (FileRevisionExtraInfo frx : frxsToRetrieve.keySet()) {
                Integer toRev;
                Pair<Integer, Integer> sliderRevs = this.frxSliderRevisions.get(frx.getId());
                if (sliderRevs == null) continue;
                FRXDO frxDO = this.getContentManager().makeFRXDO(frx, currentUser, TotalityFilter.getCurrentPrincipal(), this.currentUserPermissions, "", false, false, false);
                Integer fromRev = sliderRevs.getFirst();
                if (fromRev != null) {
                    frxDO.setFromFrxRevision(frxRevisionManager.getById(fromRev));
                }
                if ((toRev = sliderRevs.getSecond()) != null) {
                    frxDO.setToFrxRevision(frxRevisionManager.getById(toRev));
                }
                frxDO.mapInlineComments();
                for (InlineComment inlineComment : (Set)frxsToRetrieve.get(frx)) {
                    this.updatedInlineComments.add(frxDO.getIcDOFromComment(inlineComment.getComment()));
                }
            }
        }
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.generateComments();
        return "success";
    }
}

