/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.view.ReviewRowDetail;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RSSReviewQueryAction
extends BaseAction {
    private List<ReviewRowDetail> reviewRowDetails = null;
    private ReviewFilters reviewFilters;
    private String filter;
    private ReviewFilterDef customFD;
    private String title;
    @Autowired
    private ProjectManager projectManager;

    private ReviewFilters getReviewFilters() {
        if (this.reviewFilters == null) {
            this.reviewFilters = new ReviewFilters(this.getCurrentUser());
        }
        return this.reviewFilters;
    }

    private ReviewFilterDef getCustomFD() {
        if (this.customFD == null) {
            this.customFD = this.getReviewFilters().getCustomFilterDef();
        }
        return this.customFD;
    }

    public void setUser(String userName) {
        FecruUser user = this.userManager.getUser(userName);
        this.getReviewFilters().setUser(user);
    }

    public void setProject(String project) {
        this.getReviewFilters().setProject(this.projectManager.getProjectByKey(project));
        this.getCustomFD().project = this.projectManager.getProjectByKey(project);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilterDesc() {
        return this.getFilterDefByName((String)this.filter).filterDescription;
    }

    public String getFilterName() {
        return this.getFilterDefByName((String)this.filter).filterName;
    }

    public String getSiteurl() {
        return CrucibleFilter.getSiteURL();
    }

    public Date getDate() {
        return new Date();
    }

    public void setState(String[] state) {
        this.getCustomFD().state = state;
    }

    public void setAuthor(String author) {
        this.getCustomFD().author = this.userManager.getUser(author);
    }

    public void setModerator(String moderator) {
        this.getCustomFD().moderator = this.userManager.getUser(moderator);
    }

    public void setCreator(String creator) {
        this.getCustomFD().creator = this.userManager.getUser(creator);
    }

    public void setReviewer(String reviewer) {
        this.getCustomFD().reviewer = this.userManager.getUser(reviewer);
    }

    public void setOrRoles(boolean orRoles) {
        this.getCustomFD().orRoles = orRoles;
    }

    public void setComplete(Boolean complete) {
        this.getCustomFD().complete = complete;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private ReviewFilterDef getFilterDefByName(String name) {
        return this.getFilterDefByKey(ReviewFilters.FilterKey.fromId(name));
    }

    private ReviewFilterDef getFilterDefByKey(ReviewFilters.FilterKey key) {
        if (this.filter.equals(ReviewFilters.FilterKey.CUSTOM.id)) {
            ReviewFilterDef customFD = this.getCustomFD();
            if (customFD.reviewer == null && customFD.complete != null) {
                customFD.allReviewersComplete = customFD.complete;
                customFD.complete = null;
            }
            return customFD;
        }
        return this.getReviewFilters().getFilterDefByKey(key);
    }

    private List<ReviewRowDetail> getFilteredReviewDetails(ReviewFilters.FilterKey filter) {
        if (this.reviewRowDetails == null) {
            this.reviewRowDetails = new ArrayList<ReviewRowDetail>();
            ReviewFilterDef fd = this.getFilterDefByKey(filter);
            Collection<Review> matchingReviews = this.reviewManager.getMatchingReviews(fd, this.title);
            HashSet<Integer> reviewsSeen = new HashSet<Integer>();
            for (Review review : matchingReviews) {
                if (reviewsSeen.contains(review.getId()) || !ReviewUtil.principalCanDoReviewAction(this.effectiveUserProvider.getEffectivePrincipal(), this.getCurrentUser(), UserActionManager.ACTION_VIEW, review)) continue;
                reviewsSeen.add(review.getId());
                this.reviewRowDetails.add(new ReviewRowDetail(review, this.getCurrentUser()));
            }
            Collections.sort(this.reviewRowDetails, new Comparator<ReviewRowDetail>(){

                @Override
                public int compare(ReviewRowDetail r1, ReviewRowDetail r2) {
                    return r1.getCreateDate().compareTo(r2.getCreateDate());
                }
            });
        }
        return this.reviewRowDetails;
    }

    public List<ReviewRowDetail> getFilteredReviewDetails() {
        return this.getFilteredReviewDetails(ReviewFilters.FilterKey.fromId(this.filter));
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return super.execute();
    }
}

