/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.fisheye.scm.CruciblePathInfo;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import java.io.IOException;

public class PathInfoBaseAction
extends ReviewBaseAction {
    protected String actionPathInfo;
    private boolean waybackJump;
    private boolean brJump;
    private CruciblePathInfo pi;

    public String getActionPathInfo() {
        return this.actionPathInfo;
    }

    public String getActionPathInfoUrlEncoded() {
        return FishEyeURLEncoder.pathEncode(this.getActionPathInfo());
    }

    public CruciblePathInfo getPathInfo() {
        if (this.pi == null) {
            this.pi = new CruciblePathInfo(this.actionPathInfo);
        }
        return this.pi;
    }

    public void setActionPathInfo(String actionPathInfo) {
        if (actionPathInfo.startsWith("/")) {
            actionPathInfo = actionPathInfo.substring(1);
        }
        this.actionPathInfo = actionPathInfo;
    }

    public void setWbjump(String wbjump) {
        this.waybackJump = true;
    }

    public boolean getWbjump() {
        return this.waybackJump;
    }

    public void setBrjump(boolean brJump) {
        this.brJump = brJump;
    }

    protected boolean handleWaybackJump() {
        if (this.waybackJump) {
            CruciblePathInfo pi = this.getPathInfo();
            WaybackSpec wbSpec = WaybackSpec.fromRequest(this.getRequest());
            String urlsuffix = wbSpec.getUrlCommand() + "/" + pi.getFullPath().getAsUrl();
            this.setActionPathInfo(urlsuffix);
            return true;
        }
        return false;
    }

    protected boolean handleSvnConflictingBranches(RepositoryEngine engine) throws DbException, IOException {
        WaybackSpec waybackSpec = WaybackSpec.fromRequest(this.getRequest());
        if (this.brJump) {
            CruciblePathInfo pi = this.getPathInfo();
            String url = RepositoryUtil.getPhysicalPathUrl(pi.getLocalPath(), waybackSpec, engine, pi.getSourceName(), null);
            this.setActionPathInfo(url);
            return true;
        }
        return false;
    }
}

