/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.BaseAction;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.util.Collections;

public abstract class PagedSearch
extends BaseAction {
    protected static final int PAGE_LENGTH = 50;
    protected static final int MAX_PAGE_EXTEND_PERCENT = 10;
    protected String filterParams;
    protected String query;
    private TotalCountAwarePagingCalculator pages;
    private int page = 1;

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query.trim();
    }

    private int getMaxPageExtend() {
        return this.pages.getNumPerPage() * 10 / 100;
    }

    public String getSearchParams() {
        if (this.filterParams == null) {
            StringBuilder paramBuilder = new StringBuilder();
            String sep = "";
            for (String name : Collections.list(this.getRequest().getParameterNames())) {
                if (name.equals("page")) continue;
                paramBuilder.append(sep);
                paramBuilder.append(ExpressionUtil.escapeString(name));
                paramBuilder.append("=");
                paramBuilder.append(ExpressionUtil.escapeString(this.getRequest().getParameter(name)));
                sep = "&";
            }
            this.filterParams = paramBuilder.toString();
        }
        return this.filterParams;
    }

    public String getFilterParams() {
        return "X";
    }

    public int getStart() {
        return this.getPagingCalculator().getCurrentPageStart();
    }

    public int getEnd() {
        int end = this.getPagingCalculator().getCurrentPageEnd();
        int n2 = this.getPagingCalculator().getNumItems();
        if (end + this.getMaxPageExtend() > n2) {
            end = n2;
        }
        return end;
    }

    public int getNumberOfPages() {
        int d2;
        int n2 = this.getPagingCalculator().getNumItems();
        if (n2 > (d2 = this.getMaxPageExtend())) {
            n2 -= d2;
        }
        return n2 / this.getPagingCalculator().getNumPerPage() + 1;
    }

    public boolean getSomeResultsHidden() {
        return false;
    }

    public void setPage(int page) {
        this.page = Math.max(1, page);
    }

    public abstract TotalCountAwarePagingCalculator constructPagingCalculator(int var1);

    public TotalCountAwarePagingCalculator getPagingCalculator() {
        if (this.pages == null) {
            this.pages = this.constructPagingCalculator(this.page);
        }
        return this.pages;
    }
}

