/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.model.managers.LogAction;
import java.util.Date;

public class HistoryItem {
    private LogAction logAction;
    private final Date date;
    private final String description;
    private final FecruUser user;
    private final String oldValue;
    private final String newValue;
    private final Integer entityId;
    private final Integer logItemId;
    private final String entityString;
    private final CrucibleUserManager userManager;

    HistoryItem(LogItem logItem, CrucibleUserManager userManager) {
        this.date = logItem.getCreateDate();
        this.description = logItem.getDescription();
        this.logAction = LogAction.getAction(logItem.getAction());
        this.oldValue = logItem.getOldValue();
        this.newValue = logItem.getNewValue();
        this.entityId = logItem.getEntityId();
        this.logItemId = logItem.getId();
        this.entityString = logItem.getEntityString();
        this.user = CrucibleUserManager.getUserById(logItem.getUserId());
        this.userManager = userManager;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public FecruUser getUser() {
        return this.user;
    }

    public LogAction getLogAction() {
        return this.logAction;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public boolean isReviewerItem() {
        return this.logAction == LogAction.REVIEW_REVIEWER_ADDED || this.logAction == LogAction.REVIEW_REVIEWER_REMOVED || this.logAction == LogAction.REVIEW_REVIEWER_ADDED_MID_REVIEW || this.logAction == LogAction.REVIEW_REVIEWER_REMOVED_MID_REVIEW;
    }

    public FecruUser getReviewer() {
        return CrucibleUserManager.getUserById(this.entityId);
    }

    public boolean isCommentItem() {
        return this.logAction == LogAction.COMMENT_ADDED || this.logAction == LogAction.COMMENT_DELETED || this.logAction == LogAction.COMMENT_UPDATED || this.logAction == LogAction.COMMENT_CHANGED;
    }

    public Integer getEntityId() {
        if (this.entityId != null && (this.logAction == LogAction.REVIEW_REVISION_ADDED || this.logAction == LogAction.REVIEW_REVISION_REMOVED)) {
            FileRevisionExtraInfo frx;
            FRXRevisionManager frxRevisionManager = new FRXRevisionManager();
            FRXRevision frxRev = frxRevisionManager.getById(this.entityId);
            if (frxRev != null && (frx = frxRev.getFrx()) != null) {
                return frx.getId();
            }
        } else {
            return this.entityId;
        }
        return null;
    }

    public boolean isFrxItem() {
        return this.logAction == LogAction.REVIEW_FRX_ADDED || this.logAction == LogAction.REVIEW_FRX_REMOVED;
    }

    public boolean isNotDeleted() {
        return this.logAction != LogAction.COMMENT_DELETED && this.logAction != LogAction.REVIEW_FRX_REMOVED;
    }

    public boolean isFrxOrRevisionItem() {
        return this.logAction == LogAction.REVIEW_FRX_ADDED || this.logAction == LogAction.REVIEW_FRX_REMOVED || this.logAction == LogAction.REVIEW_REVISION_ADDED || this.logAction == LogAction.REVIEW_REVISION_REMOVED;
    }

    public boolean getReviewPropertyChangeItem() {
        return this.logAction == LogAction.REVIEW_ALLOW_JOIN_CHANGED || this.logAction == LogAction.REVIEW_REPOSITORY_CHANGED || this.logAction == LogAction.REVIEW_TITLE_CHANGED || this.logAction == LogAction.REVIEW_DESCRIPTION_CHANGED || this.logAction == LogAction.REVIEW_DUE_DATE_CHANGED || this.logAction == LogAction.REVIEW_AUTHOR_CHANGED || this.logAction == LogAction.REVIEW_JIRA_KEY_CHANGED || this.logAction == LogAction.REVIEW_MODERATOR_CHANGED || this.logAction == LogAction.REVIEW_PARENT_REVIEW_CHANGED || this.logAction == LogAction.REVIEW_SUMMARY_CHANGED;
    }

    public boolean isHasNoOldOrNewValues() {
        return this.newValue == null && this.oldValue == null;
    }

    public boolean isHasEitherOldOrNewValues() {
        return this.newValue == null && this.oldValue != null || this.oldValue == null && this.newValue != null;
    }

    public boolean isHasBothOldAndNewValues() {
        return this.newValue != null && this.oldValue != null;
    }

    public Integer getLogItemId() {
        return this.logItemId;
    }

    public String getEntityString() {
        return this.entityString;
    }

    public boolean isReviewerInviteItem() {
        return this.logAction == LogAction.REVIEW_REVIEWER_INVITED || this.logAction == LogAction.REVIEW_REVIEWER_UNINVITED || this.logAction == LogAction.REVIEW_REVIEWER_INVITE_ERROR;
    }
}

