/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.actions.SimpleAjaxResponse;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class FileReadStatusAjaxAction
extends ReviewBaseAction
implements SimpleAjaxResponse {
    @Autowired
    private UnreadFileManager unreadFileManager;
    private Integer[] frxIds;
    private boolean markAsRead;
    private boolean wasRead;
    private String errorMsg;
    private boolean worked;
    private ReviewParticipant currentParticipant;
    private Map<Integer, FileRevisionExtraInfo> frxIdMap;

    @Override
    public String getPayload() {
        return null;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public void setFrxId(Integer frxId) {
        this.frxIds = new Integer[]{frxId};
    }

    public void setFrxIds(Integer[] frxIds) {
        this.frxIds = frxIds;
    }

    public void setMarkAsRead(boolean read) {
        this.markAsRead = read;
    }

    @Override
    public int getValue() {
        return 0;
    }

    @Override
    public ReviewParticipant getParticipant() {
        if (this.currentParticipant == null) {
            this.currentParticipant = this.getReview().getParticipant(this.getCurrentUser());
        }
        return this.currentParticipant;
    }

    public boolean isAllowed() {
        return this.getReview().checkWriteAccess(this.getCurrentUser());
    }

    public String execute() throws Exception {
        try {
            this.beginTx();
            if (this.getCurrentUser() == null) {
                String string = this.bail("Anonymous users cannot mark files as read/unread.");
                return string;
            }
            if (!this.isAllowed()) {
                String string = this.bail("Sorry, you're not authorized to read/unread a file from this review now.");
                return string;
            }
            try {
                this.changeCommentStatuses();
            }
            catch (Exception e2) {
                String string = this.bail(e2.getMessage());
                this.rollbackTxIfNotCommited();
                return string;
            }
            this.worked = true;
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private void changeCommentStatuses() throws Exception {
        for (Integer id : this.frxIds) {
            this.changeCommentStatus(id);
        }
    }

    private FileRevisionExtraInfo getFrx(Integer id) {
        if (this.frxIdMap == null) {
            this.frxIdMap = new HashMap<Integer, FileRevisionExtraInfo>();
            for (FileRevisionExtraInfo frx : this.getReview().getFrxs()) {
                this.frxIdMap.put(frx.getId(), frx);
            }
        }
        return this.frxIdMap.get(id);
    }

    private void changeCommentStatus(Integer frxId) throws Exception {
        if (frxId == null) {
            throw new Exception("This file can't be read/unread because there was no frx ID.");
        }
        FileRevisionExtraInfo frx = this.getFrx(frxId);
        if (frx == null) {
            throw new Exception("FRX " + frxId + " doesn't exist.");
        }
        this.wasRead = this.getParticipant().isRead(frx);
        if (this.wasRead && this.markAsRead) {
            return;
        }
        boolean isLeftUnread = this.unreadFileManager.isMarkedLeaveUnread(this.getParticipant(), frx);
        if (isLeftUnread && !this.markAsRead) {
            return;
        }
        if (this.markAsRead) {
            this.unreadFileManager.markAsRead(this.getParticipant(), frx);
        } else {
            this.unreadFileManager.markAsLeaveUnread(this.getParticipant(), frx);
        }
    }

    private String bail(String errorMessage) {
        this.commitTx();
        this.setErrorMsg(errorMessage);
        return "error";
    }
}

