/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.fisheye.logging.Logs;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DownloadPatchAction
extends ReviewBaseAction {
    public static final String ERROR_NO_SUCH_PATCH = "No such patch ";
    public static final String ERROR_UNABLE_TO_FIND_REQUESTED_REVIEW = "Unable to find requested review ";
    private static final Pattern ACTION_PATH_PROG = Pattern.compile("^/?(\\d+).*");
    private String actionPathInfo;
    private String errorMsg = "Can't find files referenced by ";
    private String contentType = "text/plain";
    private InputStream inputStream;

    public void setActionPathInfo(String path) {
        this.actionPathInfo = path;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    @RequireSecurityToken(value=false)
    public String execute() {
        return this.txTemplate.execute(status -> {
            try {
                return this.doDownload();
            }
            catch (Exception e2) {
                status.setRollbackOnly();
                Logs.APP_LOG.error((Object)"Problem getting patch", (Throwable)e2);
                this.errorMsg = "Problem getting patch: " + e2.getMessage();
                return "error";
            }
        });
    }

    private String doDownload() throws IOException {
        Matcher m2 = ACTION_PATH_PROG.matcher(this.actionPathInfo);
        if (m2.matches()) {
            int patchid = Integer.parseInt(m2.group(1));
            return this.setupPatchDownload(patchid);
        }
        this.errorMsg = "Patch id not specified";
        return "error";
    }

    private String setupPatchDownload(int patchid) throws IOException {
        Patch patch = this.patchManager.getPatchById(patchid);
        if (patch == null || patch.getReview() != this.getReview()) {
            this.errorMsg = ERROR_NO_SUCH_PATCH + patchid;
            return "error";
        }
        if (!this.hasReviewPermission(UserActionManager.ACTION_VIEW, this.getReview())) {
            this.errorMsg = ERROR_UNABLE_TO_FIND_REQUESTED_REVIEW + this.getReview().getPermaId();
            return "error";
        }
        UploadItem item = patch.getUploadItem();
        this.inputStream = this.createPatchInputStream(item);
        if (item.getOriginalContentType() != null) {
            this.contentType = item.getOriginalContentType();
        }
        return "success";
    }

    protected boolean hasReviewPermission(String actionName, Review review) {
        PermissionScheme ps = review.getProject().getPermissionScheme();
        return this.permissionManager.canPrincipalDoAction(ps, this.effectiveUserProvider.getEffectivePrincipal(), null, actionName, review);
    }

    protected BufferedInputStream createPatchInputStream(UploadItem item) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(item.getItemFile()));
    }

    public String getError() {
        return "error.general";
    }

    public String getErrorDescription() {
        return this.errorMsg;
    }
}

