/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fisheye.jira.issue.JiraIssueService;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.view.ReviewDO;
import org.springframework.beans.factory.annotation.Autowired;

public class CruReviewTooltipAction
extends BaseAction {
    private String key;
    private Review review;
    private ReviewDO reviewDO;
    private boolean visibleForUser = false;
    @Autowired
    private JiraIssueService jiraIssueService;
    @Autowired
    private CurrentUserPermissions currentUserPermissions;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.review = this.reviewManager.getReviewByPermaId(this.key);
        this.visibleForUser = ReviewUtil.canDoReviewAction(UserActionManager.ACTION_VIEW, this.review);
        return "success";
    }

    public Review getReview() {
        return this.review;
    }

    public ReviewDO getReviewDO() {
        if (this.reviewDO == null) {
            this.reviewDO = new ReviewDO(this.getReview(), this.getPrincipal(), this.currentUserPermissions, this.jiraIssueService);
        }
        return this.reviewDO;
    }

    public boolean isVisibleForUser() {
        return this.visibleForUser;
    }
}

