/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.HistoryItem;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.managers.LogAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ConsolidatedHistoryItems {
    private List<HistoryItem> items = new ArrayList<HistoryItem>();
    private Date timeStart;
    private Date timeEnd;
    private FecruUser user;
    private LogAction logAction;
    private String externalActionName;

    public ConsolidatedHistoryItems(HistoryItem historyItem, TimePeriod timePeriod) {
        this.items.add(historyItem);
        this.user = historyItem.getUser();
        this.logAction = historyItem.getLogAction();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(historyItem.getDate());
        this.timeStart = calendar.getTime();
        switch (timePeriod) {
            case MINUTE: {
                calendar.add(12, 1);
                break;
            }
            case HOUR: {
                calendar.add(10, 1);
            }
        }
        this.timeEnd = calendar.getTime();
        this.externalActionName = this.logAction == LogAction.EXTERNAL ? historyItem.getEntityString() : null;
    }

    public boolean canConsolidate(LogItem item) {
        return this.user != null && item.getUserId() != null && this.logAction != null && item.getAction() != null && this.logAction.getPluralDescription() != null && item.getUserId().equals(this.user.getId()) && item.getAction().equals(this.logAction.getKey()) && item.getCreateDateTime() >= this.timeStart.getTime() && item.getCreateDateTime() < this.timeEnd.getTime();
    }

    public void add(HistoryItem item) {
        this.items.add(item);
    }

    public Date getDate() {
        return this.timeStart;
    }

    public Long getEndDate() {
        return this.timeEnd.getTime();
    }

    public FecruUser getUser() {
        return this.user;
    }

    public String getAction() {
        if (this.externalActionName != null) {
            return this.externalActionName;
        }
        if (this.items.size() > 1) {
            return this.logAction.getPluralDescription();
        }
        return this.logAction.getDescription();
    }

    public List<HistoryItem> getItems() {
        return this.items;
    }

    public LogAction getLogAction() {
        return this.logAction;
    }

    public String getAvatarUrl() {
        return this.user == null ? null : AvatarTypeInfo.getAvatarUrl(this.user, (Integer)15);
    }

    public static enum TimePeriod {
        MINUTE,
        HOUR;

    }
}

