/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewAction;
import com.atlassian.fecru.template.TemplateManager;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.util.EmailAllCommentsFormatter;
import com.cenqua.crucible.util.FreemarkerUtil;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class CommentsAsTextAction
extends ReviewAction
implements AjaxResponse {
    private static final String TEMPLATE = "review-allcomments.ftl";
    @Autowired
    private TemplateManager templateManager;
    private String message;

    @Override
    public String getErrorMsg() {
        return "";
    }

    @Override
    public boolean isWorked() {
        return true;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.message = this.buildMessage(this.getContext());
        return "success";
    }

    public Map<String, Object> getContext() {
        Map<String, Object> attribs = FreemarkerUtil.init();
        ArrayList<Comment> reviewComments = new ArrayList<Comment>();
        Set<FileRevisionExtraInfo> frxs = this.getReview().getFrxs();
        for (FileRevisionExtraInfo frx : frxs) {
            for (FRXComment comment : frx.getFrxComments()) {
                reviewComments.add(comment.getComment());
            }
            ArrayList<InlineComment> inlineComments = new ArrayList<InlineComment>(frx.getInlineComments());
            Collections.sort(inlineComments, new DefaultCommentManager.CommentPairComparator());
            for (InlineComment inlineComment : inlineComments) {
                reviewComments.add(inlineComment.getComment());
            }
        }
        attribs.put("frxComments", reviewComments);
        attribs.put("commentManager", DefaultCommentManager.getInstance());
        attribs.put("review", this.getReview());
        attribs.put("formatter", new EmailAllCommentsFormatter());
        return attribs;
    }

    public String buildMessage(Map<String, Object> attribs) throws IOException, TemplateException {
        Template template = this.templateManager.getCrucibleTemplate(TEMPLATE, false);
        StringWriter writer = new StringWriter();
        template.process(attribs, (Writer)writer);
        writer.flush();
        return writer.toString();
    }
}

