/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.actions.search.ajax.AjaxAutocompleter;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.quicknav.UserSearchResult;
import com.atlassian.fecru.search.quicknav.UserSearcher;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.util.EmailUtil;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseUserFinderAjaxAction
extends BaseAction
implements AjaxAutocompleter<UserSearchResult> {
    public static final String ALL_USERS_DISPLAYNAME = "All users";
    private String q;
    private int limit = 25;
    private boolean includeQueryAsEmail = false;
    private Iterable<UserSearchResult> matchedUsers = Collections.emptyList();
    private final GlobalPermissionType permission;
    private boolean allowEmpty;
    @Autowired
    UserSearcher userSearcher;

    public BaseUserFinderAjaxAction(GlobalPermissionType permission) {
        this.permission = permission;
    }

    @Override
    public void setQ(String q2) {
        this.q = q2;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public Collection<UserSearchResult> getMatches() {
        List sorted = Ordering.from(UserSearchResult.DISPLAY_NAME_COMPARATOR).sortedCopy(Iterables.limit(this.matchedUsers, (int)this.limit));
        if (this.allowEmpty) {
            sorted.add(0, new UserSearchResult(-1, "", ALL_USERS_DISPLAYNAME, ""));
        }
        return sorted;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.matchedUsers = this.userSearcher.search(this.q, SearchScope.builder().withTo(this.limit).build(), this.permission);
        return "success";
    }

    @Override
    public String getErrorMsg() {
        return "";
    }

    @Override
    public boolean isWorked() {
        return true;
    }

    public boolean isIncludeQueryAsEmail() {
        return this.includeQueryAsEmail;
    }

    public void setIncludeQueryAsEmail(boolean includeQueryAsEmail) {
        this.includeQueryAsEmail = includeQueryAsEmail;
    }

    public boolean isValidEmail() {
        return EmailUtil.isValidEmail(this.q);
    }

    public String getQueryAsEmailAddress() {
        if (this.q != null && this.isValidEmail()) {
            return this.q.trim();
        }
        return null;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }
}

