/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.event.ReviewUpdatedEvent;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewMutableProperties;
import com.cenqua.crucible.model.managers.UserActionManager;
import javax.annotation.Resource;

public abstract class BaseUpdateReviewPropertyAjaxAction<T>
extends ReviewBaseAction
implements AjaxResponse {
    private String errorMsg;
    private boolean worked;
    private T input;
    @Resource
    private SPIUtils spiUtils;

    public abstract T getCurrentPropertyValue();

    protected abstract void updateCurrentPropertyValue(T var1);

    public abstract ReviewUpdatedEvent createUpdateEvent(Review var1, String var2, UserData var3, ReviewData var4);

    public abstract ReviewMutableProperties getPropertyLogField();

    public abstract String getLogPropertyValue(T var1);

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public T getInput() {
        return this.input;
    }

    public void setInput(T input) {
        this.input = input;
    }

    protected void log(ReviewMutableProperties property, String oldValue, String newValue) {
        LogManager.logReviewPropertyChanged(property, this.getReview(), this.getCurrentUser(), oldValue, newValue);
    }

    private boolean changed(T newVal, T currentVal) {
        if (newVal == null && currentVal == null) {
            return false;
        }
        if (newVal == null || currentVal == null) {
            return true;
        }
        return !newVal.equals(currentVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        if (this.getReview().getState().isClosedMetaState()) {
            this.errorMsg = "Cannot edit details of a closed review.";
            this.worked = false;
            return "ajaxError";
        }
        if (!this.isFileModifiable()) {
            UserActionManager userActionManager = UserActionManager.getInstance();
            this.errorMsg = userActionManager.getAction(UserActionManager.ACTION_MOD_FILES).getPermissionViolationMsg();
            this.worked = false;
            return "ajaxError";
        }
        if (!this.changed(this.input, this.getCurrentPropertyValue())) {
            this.worked = true;
            return "success";
        }
        try {
            ReviewData oldReviewData = this.spiUtils.createReviewData(this.getReview());
            this.beginTx();
            T currentValue = this.getCurrentPropertyValue();
            this.log(this.getPropertyLogField(), this.getLogPropertyValue(currentValue), this.getLogPropertyValue(this.input));
            this.updateCurrentPropertyValue(this.input);
            this.commitTx();
            this.eventPublisher.publish((Object)this.createUpdateEvent(this.getReview(), this.getLogPropertyValue(currentValue), this.getCurrentUserData(), oldReviewData));
            this.worked = true;
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

