/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.services.SearchService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.cenqua.crucible.hibernate.TxHelper;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.PreferenceManager;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.hibernate.exception.GenericJDBCException;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    protected UserManager userManager;
    @Resource
    protected SearchService searchService;
    @Resource
    protected PermissionManager permissionManager;
    @Resource
    private SecureProjectManager secureProjectManager;
    @Resource
    protected EventPublisher eventPublisher;
    private TxHelper txHelper = new TxHelper();
    private List<FecruUser> userCache;
    protected ProjectManager projectManager;
    protected TxTemplate txTemplate;
    private WebResourceManager webResourceManager;
    private List<Project> projects;
    protected SourceFactory sourceFactory;
    protected ReviewManager reviewManager;
    protected EffectiveUserProvider effectiveUserProvider;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private SPIUserUtils spiUserUtils;

    @Autowired
    public void setReviewManager(ReviewManager reviewManager) {
        this.reviewManager = reviewManager;
    }

    public void setTxTemplate(TxTemplate txTemplate) {
        this.txTemplate = txTemplate;
    }

    @Autowired
    public void setEffectiveUserProvider(EffectiveUserProvider effectiveUserProvider) {
        this.effectiveUserProvider = effectiveUserProvider;
    }

    @Autowired
    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Autowired
    public void setSPIUserUtils(SPIUserUtils spiUserUtils) {
        this.spiUserUtils = spiUserUtils;
    }

    @Autowired
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public CookiePreferences getUserPreferences() {
        return PreferenceManager.getPreferences(this.request);
    }

    public void setAttribute(String name, Object attrib) {
        this.request.setAttribute(name, attrib);
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Principal getPrincipal() {
        return this.effectiveUserProvider.getEffectivePrincipal();
    }

    public FecruUser getCurrentUser() {
        return this.effectiveUserProvider.getEffectiveUser();
    }

    public UserData getCurrentUserData() {
        return this.spiUserUtils.createUserData(this.getCurrentUser());
    }

    public List<FecruUser> getUsers() throws DbException {
        if (this.userCache == null) {
            this.userCache = this.userManager.getLicensedUsers();
        }
        return this.userCache;
    }

    @Deprecated
    protected void beginTx() {
        this.txHelper.beginTx();
    }

    @Deprecated
    protected void commitTx() {
        try {
            this.txHelper.commitTx();
        }
        catch (GenericJDBCException e2) {
            Logs.APP_LOG.error((Object)e2.getMessage(), (Throwable)e2);
            throw e2;
        }
    }

    @Deprecated
    protected void rollbackTxIfNotCommited() {
        this.txHelper.rollbackTxIfNotCommitted();
    }

    public Collection<Source> getRepositories() {
        return this.sourceFactory.getSources(this.getPrincipal());
    }

    public Source getDefaultRepo() {
        Project p2 = this.getProject();
        if (p2 != null && !StringUtils.isEmpty((String)p2.getDefaultRepositoryName())) {
            return this.sourceFactory.getSource(p2.getDefaultRepositoryName(), this.getPrincipal());
        }
        Collection<Source> repos = this.getRepositories();
        for (Source repo : repos) {
            if (!repo.isAvailable()) continue;
            return repo;
        }
        return null;
    }

    protected Project getProject() {
        return null;
    }

    public String getCookedRSSNoteURL() throws DbException {
        LoginCookie cookie = AppConfig.getsConfig().getUserManager().preCookUrl(this.request, "/cru/rss", true);
        return cookie == null ? "" : cookie.getLoginCookieToken().encode();
    }

    public List<Project> getProjectList() {
        if (this.projects == null) {
            this.projects = this.secureProjectManager.getVisibleProjects(this.getPrincipal());
        }
        return this.projects;
    }

    public List<Project> getProjectsCanCreateIn() {
        return this.secureProjectManager.getProjectsCanCreateIn(this.getPrincipal());
    }

    public List<Project> getProjectsCanDoActionIn(UserActionManager.Action action) {
        List<Project> projects = this.secureProjectManager.getProjectsCanDoActionIn(this.getPrincipal(), action);
        Collections.sort(projects, new Project.NameComparator());
        return projects;
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public void setSourceFactory(SourceFactory sourceFactory) {
        this.sourceFactory = sourceFactory;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }
}

