/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.AbstractArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.MultiplexedOutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.zip.ZipEntry;
import de.schlichtherle.io.archive.zip.ZipInputArchive;
import de.schlichtherle.io.archive.zip.ZipOutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;

public class ZipDriver
extends AbstractArchiveDriver {
    private static final long serialVersionUID = -7061546656075796996L;
    static final String TEMP_FILE_PREFIX = "tzp-zip";
    public static final String DEFAULT_CHARSET = "IBM437";
    public static final int DEFAULT_LEVEL = 9;
    private final boolean preambled;
    private final boolean postambled;
    private final int level;

    public ZipDriver() {
        this(DEFAULT_CHARSET, null, null, false, false, 9);
    }

    public ZipDriver(String charset) {
        this(charset, null, null, false, false, 9);
    }

    public ZipDriver(int level) {
        this(DEFAULT_CHARSET, null, null, false, false, level);
    }

    public ZipDriver(String charset, boolean preambled, boolean postambled, Icon openIcon, Icon closedIcon) {
        this(charset, openIcon, closedIcon, preambled, postambled, 9);
    }

    public ZipDriver(String charset, Icon openIcon, Icon closedIcon, boolean preambled, boolean postambled, int level) {
        super(charset, openIcon, closedIcon);
        if ((level < 0 || level > 9) && level != -1) {
            throw new IllegalArgumentException();
        }
        this.preambled = preambled;
        this.postambled = postambled;
        this.level = level;
    }

    public final boolean getPreambled() {
        return this.preambled;
    }

    public final boolean getPostambled() {
        return this.postambled;
    }

    public final int getLevel() {
        return this.level;
    }

    public ArchiveEntry createArchiveEntry(Archive archive, String entryName, ArchiveEntry template) throws CharConversionException {
        ZipEntry entry;
        this.ensureEncodable(entryName);
        if (template != null) {
            if (template instanceof ZipEntry) {
                entry = this.createZipEntry((ZipEntry)template);
                entry.setName(entryName);
            } else {
                entry = this.createZipEntry(entryName);
                entry.setTime(template.getTime());
                entry.setSize(template.getSize());
            }
        } else {
            entry = this.createZipEntry(entryName);
        }
        return entry;
    }

    protected ZipEntry createZipEntry(ZipEntry template) {
        return new ZipEntry(template);
    }

    protected ZipEntry createZipEntry(String entryName) {
        return new ZipEntry(entryName);
    }

    public InputArchive createInputArchive(Archive archive, ReadOnlyFile rof) throws IOException {
        return this.createZipInputArchive(archive, rof);
    }

    protected ZipInputArchive createZipInputArchive(Archive archive, ReadOnlyFile rof) throws IOException {
        return new ZipInputArchive(rof, this.getCharset(), this.getPreambled(), this.getPostambled());
    }

    protected ZipInputArchive createZip32InputArchive(Archive archive, ReadOnlyFile rof) throws IOException {
        return this.createZipInputArchive(archive, rof);
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream out, InputArchive source) throws IOException {
        return new MultiplexedOutputArchive(this.createZipOutputArchive(archive, out, (ZipInputArchive)source));
    }

    protected ZipOutputArchive createZipOutputArchive(Archive archive, OutputStream out, ZipInputArchive source) throws IOException {
        return new ZipOutputArchive(out, this.getCharset(), this.level, source);
    }

    protected ZipOutputArchive createZip32OutputArchive(Archive archive, OutputStream out, ZipInputArchive source) throws IOException {
        return this.createZipOutputArchive(archive, out, source);
    }
}

