/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.plugin;

import com.cenqua.fisheye.user.plugin.AbstractFishEyeAuthenticator;
import com.cenqua.fisheye.user.plugin.AuthToken;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ExampleFishEyeHttpAuthenticator
extends AbstractFishEyeAuthenticator {
    private Set remoteAddrs;

    @Override
    public AuthToken checkRequest(HttpServletRequest request) {
        System.out.println("checkRequest(" + request.getRemoteAddr() + ")");
        String addr = request.getRemoteAddr();
        if (this.remoteAddrs.contains(addr)) {
            return new ExampleAuthToken(addr);
        }
        return null;
    }

    @Override
    public boolean isRequestUserStillValid(String username, HttpServletRequest req) {
        return true;
    }

    @Override
    public void init(Properties cfg) throws Exception {
        System.out.println("init(" + cfg + ")");
        String property = cfg.getProperty("allow.from");
        this.remoteAddrs = property != null ? new HashSet<String>(Arrays.asList(property.split(","))) : new HashSet();
    }

    @Override
    public void close() {
        System.out.println("close()");
        this.remoteAddrs = null;
    }

    @Override
    public AuthToken checkPassword(String username, String password) {
        System.out.println("checkPassword(" + username + ", " + password + ")");
        return null;
    }

    @Override
    public AuthToken recreateAuth(String username) {
        System.out.println("recreateAuth(" + username + ")");
        return null;
    }

    @Override
    public boolean hasPermissionToAccess(AuthToken tok, String repname, String constraint) {
        System.out.println("hasPermissionToAccess(" + tok + ", " + repname + ", " + constraint + ")");
        return true;
    }

    private static class ExampleAuthToken
    implements AuthToken {
        private final String name;

        public ExampleAuthToken(String name) {
            this.name = name;
        }

        @Override
        public String getUsername() {
            System.out.println("ExampleAuthToken.getUsername()");
            return this.name;
        }

        @Override
        public String getEmail() {
            System.out.println("ExampleAuthToken.getEmail()");
            return this.name + "@email";
        }

        @Override
        public String getDisplayName() {
            System.out.println("ExampleAuthToken.getDisplayName()");
            return this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        }
    }
}

