/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.data;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="repository")
public class RepositoryDataFE {
    private String name;
    private boolean enabled;
    private boolean finishedFullSlurp;
    private RepositoryState state;

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setState(RepositoryState state) {
        this.state = state;
    }

    public void setFinishedFullSlurp(boolean finishedInitialSlurp) {
        this.finishedFullSlurp = finishedInitialSlurp;
    }

    public RepositoryDataFE(String name, boolean enabled, RepositoryState state, boolean finishedFullSlurp) {
        this.setName(name);
        this.setEnabled(enabled);
        this.setState(state);
        this.setFinishedFullSlurp(finishedFullSlurp);
    }

    public RepositoryDataFE() {
    }

    @XmlAttribute(name="repositoryState")
    public RepositoryState getState() {
        return this.state;
    }

    @XmlAttribute
    public boolean isEnabled() {
        return this.enabled;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @XmlAttribute
    public boolean isFinishedFullSlurp() {
        return this.finishedFullSlurp;
    }

    public String toString() {
        return this.getName() + ": state:" + (Object)((Object)this.getState()) + " enabled:" + this.isEnabled() + " finishedFullSlurp:" + this.isFinishedFullSlurp();
    }

    public static enum RepositoryState {
        RUNNING("Running"),
        STOPPING("Stopping"),
        STOPPED("Stopped"),
        STARTING("Starting"),
        UNKNOWN("Unknown");

        private static Map<String, RepositoryState> descriptions;
        private final String description;

        private RepositoryState(String s) {
            this.description = s;
        }

        public String getDescription() {
            return this.description;
        }

        public static RepositoryState getState(String description) {
            if (descriptions.containsKey(description)) {
                return descriptions.get(description);
            }
            return UNKNOWN;
        }

        static {
            descriptions = new HashMap<String, RepositoryState>(RepositoryState.values().length){
                {
                    for (RepositoryState state : RepositoryState.values()) {
                        this.put(state.description, state);
                    }
                }
            };
        }
    }
}

