/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.data;

import com.atlassian.fisheye.spi.data.FileRevisionData;
import com.atlassian.fisheye.spi.data.FileRevisionKeyData;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="changeset")
public class ChangesetDataFE
implements Comparable<ChangesetDataFE> {
    private String repositoryName;
    private String csid;
    private String displayId;
    private String position;
    private Set<String> parents;
    private Set<String> children;
    private Date date;
    private String author;
    private Set<String> branches;
    private Set<String> tags;
    private String comment;
    private Iterable<FileRevisionKeyData> fileRevisions;
    private Iterable<FileRevisionData> fileRevisionsData;
    private int numFileRevisions;
    private Collection<String> p4JobIds;

    @Deprecated
    public ChangesetDataFE(String csid, Date date, String author, String branch, String comment, List<FileRevisionKeyData> revs) {
        this(csid, date, author, comment, branch != null ? Collections.singleton(branch) : null, null, null, null, revs, null);
    }

    @Deprecated
    public ChangesetDataFE(String csid, Date date, String author, String comment, Set<String> branches, Set<String> tags, Set<String> parents, Set<String> children, List<FileRevisionKeyData> revs, String position) {
        this(null, csid, csid, date, author, comment, branches, tags, parents, children, Collections.unmodifiableList(revs), null, revs.size(), position, null);
    }

    @Deprecated
    public ChangesetDataFE(String csid, String displayId, Date date, String author, String comment, Set<String> branches, Set<String> tags, Set<String> parents, Set<String> children, List<FileRevisionKeyData> revs, String position) {
        this(null, csid, displayId, date, author, comment, branches, tags, parents, children, Collections.unmodifiableList(revs), null, revs.size(), position, null);
    }

    @Deprecated
    public ChangesetDataFE(String csid, Date date, String author, String comment, Set<String> branches, Set<String> tags, Set<String> parents, Set<String> children, Iterable<FileRevisionKeyData> revs, int numFileRevisions, String position) {
        this(null, csid, csid, date, author, comment, branches, tags, parents, children, revs, null, numFileRevisions, position, null);
    }

    @Deprecated
    public ChangesetDataFE(String csid, String displayId, Date date, String author, String comment, Set<String> branches, Set<String> tags, Set<String> parents, Set<String> children, Iterable<FileRevisionKeyData> revs, int numFileRevisions, String position) {
        this(null, csid, displayId, date, author, comment, branches, tags, parents, children, revs, null, numFileRevisions, position, null);
    }

    public ChangesetDataFE(String repositoryName, String csid, String displayId, Date date, String author, String comment, Set<String> branches, Set<String> tags, Set<String> parents, Set<String> children, Iterable<FileRevisionKeyData> revs, Iterable<FileRevisionData> fileRevisionsData, int numFileRevisions, String position, Collection<String> p4JobIds) {
        this.repositoryName = repositoryName;
        this.csid = csid;
        this.displayId = displayId;
        this.date = date;
        this.author = author;
        this.branches = branches;
        this.tags = tags;
        this.comment = comment;
        this.parents = parents;
        this.children = children;
        this.fileRevisionsData = fileRevisionsData;
        this.position = position;
        this.fileRevisions = revs;
        this.numFileRevisions = numFileRevisions;
        this.p4JobIds = p4JobIds;
    }

    public ChangesetDataFE() {
    }

    @XmlAttribute
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @XmlAttribute
    public String getCsid() {
        return this.csid;
    }

    @XmlAttribute
    public String getDisplayId() {
        return this.displayId;
    }

    @XmlAttribute
    public Date getDate() {
        return this.date;
    }

    @XmlAttribute
    public String getAuthor() {
        return this.author;
    }

    @XmlAttribute
    @Deprecated
    public String getBranch() {
        return this.branches != null && this.branches.size() > 0 ? this.branches.iterator().next() : null;
    }

    @XmlElementWrapper(name="branches")
    @XmlElement(name="branch")
    public Set<String> getBranches() {
        return this.branches;
    }

    @XmlElementWrapper(name="tags")
    @XmlElement(name="tag")
    public Set<String> getTags() {
        return this.tags;
    }

    @XmlElement
    public String getComment() {
        return this.comment;
    }

    @Deprecated
    @XmlElement(name="fileRevisionKey")
    public List<FileRevisionKeyData> getFileRevisions() {
        ArrayList<FileRevisionKeyData> revs = new ArrayList<FileRevisionKeyData>(this.numFileRevisions);
        Iterables.addAll(revs, this.fileRevisions);
        return revs;
    }

    @XmlAttribute
    public String getPosition() {
        return this.position;
    }

    @XmlElementWrapper(name="parents")
    @XmlElement(name="parent")
    public Set<String> getParents() {
        return this.parents;
    }

    @XmlElementWrapper(name="children")
    @XmlElement(name="child")
    public Set<String> getChildren() {
        return this.children;
    }

    @XmlElementWrapper(name="p4JobIds")
    @XmlElement(name="p4JobId")
    public Collection<String> getP4JobIds() {
        return this.p4JobIds;
    }

    public String toString() {
        return "Changeset " + this.getCsid() + ", " + "repository: " + this.getRepositoryName() + ", " + "date: " + this.getDate() + ", " + "author: " + this.getAuthor() + ", " + "branches: [" + StringUtils.join(this.branches, (String)", ") + "], " + "tags: [" + StringUtils.join(this.tags, (String)", ") + "], " + "comment: " + this.getComment() + ", " + "revisions: " + this.getFileRevisions() + ", " + "p4JobIds: " + this.getP4JobIds();
    }

    public void setCsid(String csid) {
        this.csid = csid;
    }

    public void setDisplayId(String displayId) {
        this.displayId = displayId;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Deprecated
    public void setBranch(String branch) {
        this.branches = branch != null ? Collections.singleton(branch) : null;
    }

    public void setBranches(Set<String> branches) {
        this.branches = branches;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setRevisions(Iterable<FileRevisionKeyData> fileRevisionList) {
        this.fileRevisions = fileRevisionList;
    }

    public void setRevisions(List<FileRevisionKeyData> fileRevisionList) {
        this.fileRevisions = fileRevisionList;
        this.numFileRevisions = fileRevisionList.size();
    }

    @XmlTransient
    public Iterable<FileRevisionKeyData> getRevisionsIterable() {
        return this.fileRevisions;
    }

    @XmlTransient
    public Iterable<FileRevisionData> getRevisionsDataIterable() {
        return this.fileRevisionsData;
    }

    @XmlTransient
    @Deprecated
    public List<FileRevisionKeyData> getRevisions() {
        return this.getFileRevisions();
    }

    @XmlTransient
    public int getNumFileRevisions() {
        return this.numFileRevisions;
    }

    public void setNumFileRevisions(int numFileRevisions) {
        this.numFileRevisions = numFileRevisions;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setParents(Set<String> parents) {
        this.parents = parents;
    }

    public void setChildren(Set<String> children) {
        this.children = children;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof ChangesetDataFE && this.getCsid().equals(((ChangesetDataFE)obj).getCsid());
    }

    public int hashCode() {
        return this.getCsid() != null ? this.getCsid().hashCode() : 0;
    }

    @Override
    public int compareTo(ChangesetDataFE other) {
        if (this.equals(other)) {
            return 0;
        }
        return this.getPosition().compareTo(other.getPosition());
    }

    public static ChangesetDataFEBuilder newBuilder() {
        return new ChangesetDataFEBuilder();
    }

    public static class ChangesetDataFEBuilder {
        private String repositoryName;
        private String csid;
        private String displayId;
        private String order;
        private Set<String> parents;
        private Set<String> children;
        private Date date;
        private String author;
        private Set<String> branches;
        private Set<String> tags;
        private String comment;
        private Iterable<FileRevisionKeyData> fileRevisions = Collections.emptyList();
        private Iterable<FileRevisionData> fileRevisionsData = Collections.emptyList();
        private int numRevisions;
        private Collection<String> p4JobIds;

        public ChangesetDataFE build() {
            return new ChangesetDataFE(this.repositoryName, this.csid, this.displayId, this.date, this.author, this.comment, this.branches, this.tags, this.parents, this.children, this.fileRevisions, this.fileRevisionsData, this.numRevisions, this.order, this.p4JobIds);
        }

        public ChangesetDataFEBuilder setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public ChangesetDataFEBuilder setCsid(String csid) {
            this.csid = csid;
            return this;
        }

        public ChangesetDataFEBuilder setDisplayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public ChangesetDataFEBuilder setOrder(String order) {
            this.order = order;
            return this;
        }

        public ChangesetDataFEBuilder setParents(Set<String> parents) {
            this.parents = parents;
            return this;
        }

        public ChangesetDataFEBuilder setChildren(Set<String> children) {
            this.children = children;
            return this;
        }

        public ChangesetDataFEBuilder setDate(Date date) {
            this.date = date;
            return this;
        }

        public ChangesetDataFEBuilder setAuthor(String author) {
            this.author = author;
            return this;
        }

        public ChangesetDataFEBuilder setBranches(Set<String> branches) {
            this.branches = branches;
            return this;
        }

        public ChangesetDataFEBuilder setTags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public ChangesetDataFEBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public ChangesetDataFEBuilder setFileRevisions(List<FileRevisionKeyData> fileRevisions) {
            this.fileRevisions = fileRevisions;
            this.numRevisions = fileRevisions.size();
            return this;
        }

        public ChangesetDataFEBuilder setFileRevisions(Iterable<FileRevisionKeyData> fileRevisions, int numRevisions) {
            this.fileRevisions = fileRevisions;
            this.numRevisions = numRevisions;
            return this;
        }

        public ChangesetDataFEBuilder setFileRevisionsData(Iterable<FileRevisionData> fileRevisionsData) {
            this.fileRevisionsData = fileRevisionsData;
            return this;
        }

        public ChangesetDataFEBuilder setP4JobIds(Collection<String> p4JobIds) {
            this.p4JobIds = p4JobIds;
            return this;
        }
    }
}

