/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import com.atlassian.fisheye.spi.admin.data.AbstractLinker;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public class SimpleLinker
extends AbstractLinker {
    private Pattern regex;
    private String href;

    public SimpleLinker(Pattern regex, String href) {
        this.setRegex(regex);
        this.setHref(href);
    }

    public SimpleLinker(SimpleLinker sl) {
        this(sl.getRegex(), sl.getHref());
        this.setDescription(sl.getDescription());
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public void setRegex(Pattern regex) {
        Preconditions.checkNotNull((Object)regex, (Object)"regex");
        this.regex = regex;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        Preconditions.checkNotNull((Object)href, (Object)"href");
        if (!SimpleLinker.isValidHref(href)) {
            throw new IllegalArgumentException(String.format("'%s' is invalid.", href));
        }
        this.href = href;
    }

    public static boolean isValidHref(String s) {
        String v = s.replaceAll("\\$\\{\\d{1,2}?\\}", "test");
        try {
            if (new URI(v).getScheme() == null) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleLinker)) {
            return false;
        }
        SimpleLinker that = (SimpleLinker)o;
        return this.regex.equals(that.regex) && this.href.equals(that.href) && this.description != null ? this.description.equals(that.description) : that.description == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.regex.hashCode();
        result = 31 * result + this.href.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

