/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import com.atlassian.fisheye.spi.admin.ManagedRepositoriesNotSupportedException;
import com.atlassian.fisheye.spi.admin.data.AdvancedLinker;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePath;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob;
import com.atlassian.fisheye.spi.admin.data.CommitMessageSyntaxSettings;
import com.atlassian.fisheye.spi.admin.data.CustomAuthSettings;
import com.atlassian.fisheye.spi.admin.data.ExternalAuthSettings;
import com.atlassian.fisheye.spi.admin.data.SimpleLinker;
import com.atlassian.fisheye.spi.admin.data.TarballSettings;
import com.atlassian.fisheye.spi.admin.data.UpdateOptions;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RepositoryOptions {
    public static final long DEFAULT_MAX_INDEXABLE_BYTES = 102400L;
    private boolean usingDefaultsPermissions;
    private boolean allowAnon;
    private boolean allowLoggedUsers;
    private Boolean watchesEnabled = null;
    private Boolean changesetDiscussionsEnabled = null;
    private TarballSettings tarballSettings = null;
    private CommitMessageSyntaxSettings commitMessageSyntaxSettings = null;
    private ExternalAuthSettings externalAuthSettings = null;
    private Long maxIndexableSize = null;
    private UpdateOptions updateOptions;
    private List<SimpleLinker> simpleLinkers = RepositoryOptions.newArrayList();
    private List<AdvancedLinker> advancedLinkers = RepositoryOptions.newArrayList();
    private List<CaseAwarePath> allowIncludes = RepositoryOptions.newArrayList();
    private List<CaseAwarePathGlob> allowExcludes = RepositoryOptions.newArrayList();
    private List<CaseAwarePath> hiddenDirectories = RepositoryOptions.newArrayList();
    private Set<String> requiredGroups = Sets.newHashSet();
    private Boolean showCheckoutURL;
    private Map<String, String> checkoutURL;

    private static void notNull(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    private static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public RepositoryOptions() {
    }

    public RepositoryOptions(RepositoryOptions options) {
        this.setUsingDefaultsPermissions(options.isUsingDefaultsPermissions());
        this.setAllowAnon(options.isAllowAnon());
        this.setAllowLoggedUsers(options.isAllowLoggedUsers());
        this.setWatchesEnabled(options.isWatchesEnabled());
        this.setChangesetDiscussionsEnabled(options.isChangesetDiscussionsEnabled());
        ArrayList<SimpleLinker> simpleLinkers = new ArrayList<SimpleLinker>();
        for (SimpleLinker simpleLinker : options.getSimpleLinkers()) {
            simpleLinkers.add(new SimpleLinker(simpleLinker));
        }
        this.setSimpleLinkers(simpleLinkers);
        ArrayList<AdvancedLinker> advancedLinkers = new ArrayList<AdvancedLinker>();
        for (AdvancedLinker advancedLinker : options.getAdvancedLinkers()) {
            advancedLinkers.add(new AdvancedLinker(advancedLinker));
        }
        this.setAdvancedLinkers(advancedLinkers);
        ArrayList<CaseAwarePath> arrayList = new ArrayList<CaseAwarePath>();
        for (CaseAwarePath caseAwarePath : options.getAllowIncludes()) {
            arrayList.add(new CaseAwarePath(caseAwarePath));
        }
        this.setAllowIncludes(arrayList);
        ArrayList<CaseAwarePathGlob> arrayList2 = new ArrayList<CaseAwarePathGlob>();
        for (CaseAwarePathGlob capg : options.getAllowExcludes()) {
            arrayList2.add(new CaseAwarePathGlob(capg));
        }
        this.setAllowExcludes(arrayList2);
        ArrayList<CaseAwarePath> arrayList3 = new ArrayList<CaseAwarePath>();
        for (CaseAwarePath cap : options.getHiddenDirectories()) {
            arrayList3.add(new CaseAwarePath(cap));
        }
        this.setHiddenDirectories(arrayList3);
        this.setRequiredGroups(Sets.newHashSet(options.getRequiredGroups()));
        if (options.getTarballSettings() == null) {
            this.setTarballSettings(null);
        } else {
            this.setTarballSettings(new TarballSettings(options.getTarballSettings()));
        }
        if (options.getCommitMessageSyntaxSettings() == null) {
            this.setCommitMessageSyntaxSettings(null);
        } else {
            this.setCommitMessageSyntaxSettings(new CommitMessageSyntaxSettings(options.getCommitMessageSyntaxSettings()));
        }
        if (options.getExternalAuthSettings() == null) {
            this.setExternalAuthSettings(null);
        } else if (options.getExternalAuthSettings() instanceof CustomAuthSettings) {
            this.setExternalAuthSettings(new CustomAuthSettings(((CustomAuthSettings)options.getExternalAuthSettings()).getConstraint()));
        } else {
            throw new IllegalStateException("Unrecognized ExternalAuthSettings class: " + options.getExternalAuthSettings().getClass());
        }
        this.setUpdateOptions(options.getUpdateOptions());
        this.setMaxIndexableSize(options.getMaxIndexableSize());
        this.setShowCheckoutURL(options.getShowCheckoutURL());
        this.setCheckoutURL(options.getCheckoutURL());
    }

    public Long getMaxIndexableSize() {
        return this.maxIndexableSize;
    }

    public void setMaxIndexableSize(Long maxIndexableSize) {
        this.maxIndexableSize = maxIndexableSize;
    }

    public List<SimpleLinker> getSimpleLinkers() {
        return this.simpleLinkers;
    }

    public void setSimpleLinkers(List<SimpleLinker> simpleLinkers) {
        RepositoryOptions.notNull(simpleLinkers);
        this.simpleLinkers = simpleLinkers;
    }

    public List<AdvancedLinker> getAdvancedLinkers() {
        return this.advancedLinkers;
    }

    public void setAdvancedLinkers(List<AdvancedLinker> advancedLinkers) {
        RepositoryOptions.notNull(advancedLinkers);
        this.advancedLinkers = advancedLinkers;
    }

    public Boolean isWatchesEnabled() {
        return this.watchesEnabled;
    }

    public void setWatchesEnabled(Boolean enabled) {
        this.watchesEnabled = enabled;
    }

    public boolean isUsingDefaultsPermissions() {
        return this.usingDefaultsPermissions;
    }

    public void setUsingDefaultsPermissions(boolean usingDefaultsPermissions) {
        this.usingDefaultsPermissions = usingDefaultsPermissions;
    }

    public boolean isAllowAnon() {
        return this.allowAnon;
    }

    public void setAllowAnon(boolean allowAnon) {
        this.allowAnon = allowAnon;
    }

    @Deprecated
    public boolean isAllowAnonWrite() {
        return false;
    }

    @Deprecated
    public void setAllowAnonWrite(boolean allowAnonWrite) {
        throw new ManagedRepositoriesNotSupportedException();
    }

    public boolean isAllowLoggedUsers() {
        return this.allowLoggedUsers;
    }

    public void setAllowLoggedUsers(boolean allowLoggedUsers) {
        this.allowLoggedUsers = allowLoggedUsers;
    }

    @Deprecated
    public boolean isAllowLoggedUsersWrite() {
        return false;
    }

    @Deprecated
    public void setAllowLoggedUsersWrite(boolean allowLoggedUsersWrite) {
        throw new ManagedRepositoriesNotSupportedException();
    }

    public Boolean isChangesetDiscussionsEnabled() {
        return this.changesetDiscussionsEnabled;
    }

    public void setChangesetDiscussionsEnabled(Boolean changesetDiscussionsEnabled) {
        this.changesetDiscussionsEnabled = changesetDiscussionsEnabled;
    }

    public List<CaseAwarePath> getAllowIncludes() {
        return this.allowIncludes;
    }

    public void setAllowIncludes(List<CaseAwarePath> allowIncludes) {
        RepositoryOptions.notNull(allowIncludes);
        this.allowIncludes = allowIncludes;
    }

    public List<CaseAwarePathGlob> getAllowExcludes() {
        return this.allowExcludes;
    }

    public void setAllowExcludes(List<CaseAwarePathGlob> allowExcludes) {
        RepositoryOptions.notNull(allowExcludes);
        this.allowExcludes = allowExcludes;
    }

    public List<CaseAwarePath> getHiddenDirectories() {
        return this.hiddenDirectories;
    }

    public void setHiddenDirectories(List<CaseAwarePath> hiddenDirectories) {
        RepositoryOptions.notNull(hiddenDirectories);
        this.hiddenDirectories = hiddenDirectories;
    }

    public TarballSettings getTarballSettings() {
        return this.tarballSettings;
    }

    public void setTarballSettings(TarballSettings tarballSettings) {
        this.tarballSettings = tarballSettings;
    }

    public CommitMessageSyntaxSettings getCommitMessageSyntaxSettings() {
        return this.commitMessageSyntaxSettings;
    }

    public void setCommitMessageSyntaxSettings(CommitMessageSyntaxSettings commitMessageSyntaxSettings) {
        this.commitMessageSyntaxSettings = commitMessageSyntaxSettings;
    }

    public Set<String> getRequiredGroups() {
        return this.requiredGroups;
    }

    public void setRequiredGroups(Set<String> requiredGroups) {
        RepositoryOptions.notNull(requiredGroups);
        this.requiredGroups = requiredGroups;
    }

    @Deprecated
    public Set<String> getRequiredWriteGroups() {
        return Collections.emptySet();
    }

    @Deprecated
    public void setRequiredWriteGroups(Set<String> requiredWriteGroups) {
        throw new ManagedRepositoriesNotSupportedException();
    }

    public ExternalAuthSettings getExternalAuthSettings() {
        return this.externalAuthSettings;
    }

    public void setExternalAuthSettings(ExternalAuthSettings externalAuthSettings) {
        this.externalAuthSettings = externalAuthSettings;
    }

    public UpdateOptions getUpdateOptions() {
        return this.updateOptions;
    }

    public void setUpdateOptions(UpdateOptions updateOptions) {
        this.updateOptions = updateOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryOptions)) {
            return false;
        }
        RepositoryOptions that = (RepositoryOptions)o;
        return this.usingDefaultsPermissions == that.usingDefaultsPermissions && this.allowAnon == that.allowAnon && this.allowLoggedUsers == that.allowLoggedUsers && Objects.equal((Object)this.changesetDiscussionsEnabled, (Object)that.changesetDiscussionsEnabled) && Objects.equal((Object)this.watchesEnabled, (Object)that.watchesEnabled) && Objects.equal((Object)this.tarballSettings, (Object)that.tarballSettings) && Objects.equal((Object)this.commitMessageSyntaxSettings, (Object)that.commitMessageSyntaxSettings) && Objects.equal(this.simpleLinkers, that.simpleLinkers) && Objects.equal(this.advancedLinkers, that.advancedLinkers) && Objects.equal(this.allowIncludes, that.allowIncludes) && Objects.equal(this.allowExcludes, that.allowExcludes) && Objects.equal(this.hiddenDirectories, that.hiddenDirectories) && Objects.equal(this.requiredGroups, that.requiredGroups) && Objects.equal((Object)this.externalAuthSettings, (Object)that.externalAuthSettings) && Objects.equal((Object)this.maxIndexableSize, (Object)that.maxIndexableSize) && Objects.equal((Object)this.updateOptions, (Object)that.updateOptions) && Objects.equal((Object)this.showCheckoutURL, (Object)that.showCheckoutURL) && Objects.equal(this.checkoutURL, that.checkoutURL);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.usingDefaultsPermissions ? 1 : 0);
        result = 31 * result + (this.allowAnon ? 1 : 0);
        result = 31 * result + (this.allowLoggedUsers ? 1 : 0);
        return 31 * result + Objects.hashCode((Object[])new Object[]{this.changesetDiscussionsEnabled, this.watchesEnabled, this.tarballSettings, this.commitMessageSyntaxSettings, this.simpleLinkers, this.advancedLinkers, this.allowIncludes, this.allowExcludes, this.hiddenDirectories, this.requiredGroups, this.externalAuthSettings, this.maxIndexableSize, this.updateOptions, this.showCheckoutURL, this.checkoutURL});
    }

    public Boolean getShowCheckoutURL() {
        return this.showCheckoutURL;
    }

    public void setShowCheckoutURL(Boolean showCheckoutURL) {
        this.showCheckoutURL = showCheckoutURL;
    }

    public Map<String, String> getCheckoutURL() {
        return this.checkoutURL;
    }

    public void setCheckoutURL(Map<String, String> checkoutURL) {
        this.checkoutURL = checkoutURL;
    }
}

