/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import com.google.common.collect.Maps;
import java.util.Map;

public enum ImportMode {
    NO_IMPORT("none", "Do not Import"),
    IMPORT_WITHOUT_TAGS("notags", "Import without tag information");

    private static Map<String, ImportMode> keyMap;
    private final String key;
    private final String description;

    private ImportMode(String key, String description) {
        this.key = key;
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public static ImportMode fromString(String key) {
        ImportMode result = keyMap.get(key);
        return result == null ? NO_IMPORT : result;
    }

    static {
        keyMap = Maps.newHashMap();
        for (ImportMode mode : ImportMode.values()) {
            keyMap.put(mode.key, mode);
        }
    }
}

