/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import com.atlassian.fisheye.spi.admin.data.AuthenticationData;
import com.atlassian.fisheye.spi.admin.data.HasAuthenticationData;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.util.FieldValidator;

public class GitRepositoryData
extends RepositoryData
implements HasAuthenticationData {
    private String location;
    private AuthenticationData authenticationData;
    private String path;
    private Integer blockSize;
    private Integer renameOption;
    private String commandTimeout;

    public GitRepositoryData(String name, String location) {
        super(name);
        this.setLocation(location);
    }

    @Override
    public RepositoryData.Type getType() {
        return RepositoryData.Type.GIT;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        FieldValidator.INSTANCE.notBlank("location", location);
        this.location = location.startsWith("git://") && location.endsWith("/") ? location.substring(0, location.length() - 1) : location;
    }

    @Override
    public AuthenticationData getAuthentication() {
        return this.authenticationData;
    }

    @Override
    public void setAuthentication(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Integer blockSize) {
        FieldValidator.INSTANCE.positive("blockSize", blockSize);
        this.blockSize = blockSize;
    }

    public String getCommandTimeout() {
        return this.commandTimeout;
    }

    public void setCommandTimeout(String commandTimeout) {
        FieldValidator.INSTANCE.validTimeString("commandTimeout", commandTimeout);
        this.commandTimeout = commandTimeout;
    }

    public Integer getRenameOption() {
        return this.renameOption;
    }

    public void setRenameOption(Integer renameOption) {
        this.renameOption = renameOption;
    }

    @Override
    public String getLocationDescription() {
        String cleanPath;
        String cleanLocation = this.location == null || this.location.length() == 0 ? "" : this.location;
        String string = cleanPath = this.path == null || this.path.length() == 0 ? "" : this.path;
        if (cleanLocation.endsWith("/")) {
            cleanLocation = cleanLocation.substring(0, cleanLocation.length() - 1);
        }
        if (cleanPath.startsWith("/")) {
            cleanPath = cleanPath.substring(1);
        }
        return cleanLocation + "/" + cleanPath;
    }
}

