/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.page;

import com.atlassian.annotations.Internal;
import com.google.common.base.Objects;
import java.io.Serializable;
import javax.annotation.Nullable;

public class PageRequest
implements Serializable {
    public static final int MAX_PAGE_LIMIT = 1000;
    public static final int DEFAULT_PAGE_START = 0;
    public static final int DEFAULT_PAGE_LIMIT = 100;
    private static final PageRequest DEFAULT = new PageRequest(0, 100);
    private final int start;
    private final int limit;

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    @Internal
    protected PageRequest() {
        this(0, 100);
    }

    @Internal
    protected PageRequest(int start, int limit) {
        PageRequest.checkLimitOveruse(limit);
        this.start = start;
        this.limit = limit;
    }

    public static PageRequest create(@Nullable Integer start, @Nullable Integer limit) {
        PageRequest.checkLimitOveruse(limit);
        int pageRequestStart = start == null || start < 0 ? 0 : start;
        int pageRequestLimit = limit == null || limit < 0 ? 100 : Math.min(limit, 1000);
        return new PageRequest(pageRequestStart, pageRequestLimit);
    }

    public static PageRequest createDefault() {
        return DEFAULT;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.limit});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PageRequest other = (PageRequest)obj;
        return Objects.equal((Object)this.start, (Object)other.start) && Objects.equal((Object)this.limit, (Object)other.limit);
    }

    private static void checkLimitOveruse(@Nullable Integer limit) {
        if (limit != null && limit == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Limit cannot be " + limit);
        }
    }
}

