/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.services;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public enum SearchCriteriaType {
    EXACT_MATCH{

        @Override
        boolean matches(String filter, String value) {
            return filter.equals(value);
        }
    }
    ,
    PARTIAL_MATCH{

        @Override
        boolean matches(String filter, String value) {
            return StringUtils.containsIgnoreCase((String)value, (String)filter);
        }
    };


    abstract boolean matches(String var1, String var2);

    public static boolean filter(SearchCriteriaType searchCriteriaType, String filter, String value) {
        Preconditions.checkNotNull((Object)((Object)searchCriteriaType));
        return null != filter && searchCriteriaType.matches(filter, value);
    }
}

