/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.data;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.ISO8601DateAdapter;
import com.atlassian.crucible.spi.data.UserData;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
public class ReviewData
implements Serializable {
    private String projectKey;
    private String name;
    private String description;
    private UserData author;
    private UserData moderator;
    private UserData creator;
    private String permaId;
    private Set<String> permaIdHistory;
    private String summary;
    private State state;
    private ReviewType type;
    private Boolean allowReviewersToJoin;
    private int metricsVersion;
    private PermId<ReviewData> parentReview;
    private Date createDate;
    private Date closeDate;
    private Date dueDate;
    private Date reminderDate;
    private String jiraIssueKey;

    public ReviewData() {
    }

    @Deprecated
    public ReviewData(String projectKey, String name, String description, UserData author, UserData moderator, UserData creator, String permaId, String summary, State state, Boolean allowReviewersToJoin, PermId<ReviewData> parentReview, Date createDate, Date closeDate, Date dueDate, int metricsVersion, String jiraIssueKey) {
        this(projectKey, name, description, author, moderator, creator, permaId, summary, state, ReviewType.REVIEW, allowReviewersToJoin, parentReview, createDate, closeDate, dueDate, metricsVersion, jiraIssueKey);
    }

    @Deprecated
    public ReviewData(String projectKey, String name, String description, UserData author, UserData moderator, UserData creator, String permaId, String summary, State state, ReviewType type, Boolean allowReviewersToJoin, PermId<ReviewData> parentReview, Date createDate, Date closeDate, Date dueDate, int metricsVersion, String jiraIssueKey) {
        this(projectKey, name, description, author, moderator, creator, permaId, Collections.singleton(permaId), summary, state, type, allowReviewersToJoin, parentReview, createDate, closeDate, dueDate, null, metricsVersion, jiraIssueKey);
    }

    private ReviewData(String projectKey, String name, String description, UserData author, UserData moderator, UserData creator, String permaId, Set<String> permaIdHistory, String summary, State state, ReviewType type, Boolean allowReviewersToJoin, PermId<ReviewData> parentReview, Date createDate, Date closeDate, Date dueDate, Date reminderDate, int metricsVersion, String jiraIssueKey) {
        this.projectKey = projectKey;
        this.name = StringUtils.defaultString((String)name);
        this.description = description;
        this.author = author;
        this.moderator = moderator;
        this.creator = creator;
        this.permaId = permaId;
        this.permaIdHistory = permaIdHistory;
        this.summary = summary;
        this.state = state;
        this.type = type;
        this.allowReviewersToJoin = allowReviewersToJoin;
        this.parentReview = parentReview;
        this.metricsVersion = metricsVersion;
        this.createDate = createDate;
        this.closeDate = closeDate;
        this.dueDate = dueDate;
        this.reminderDate = reminderDate;
        this.jiraIssueKey = jiraIssueKey != null && jiraIssueKey.length() > 0 ? jiraIssueKey : null;
    }

    private ReviewData(String projectKey, String name, String description, UserData author, UserData moderator, UserData creator, String permaId, Set<String> permaIdHistory, String summary, State state, ReviewType type, Boolean allowReviewersToJoin, PermId<ReviewData> parentReview, Date createDate, Date closeDate, Date dueDate, int metricsVersion, String jiraIssueKey) {
        this(projectKey, name, description, author, moderator, creator, permaId, permaIdHistory, summary, state, type, allowReviewersToJoin, parentReview, createDate, closeDate, dueDate, null, metricsVersion, jiraIssueKey);
    }

    public ReviewData(ReviewData review) {
        this(review.projectKey, review.name, review.description, review.author, review.moderator, review.creator, review.permaId, review.permaIdHistory, review.summary, review.state, review.type, review.allowReviewersToJoin, review.parentReview, review.createDate, review.closeDate, review.dueDate, review.metricsVersion, review.jiraIssueKey);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAuthor(UserData author) {
        this.author = author;
    }

    public void setModerator(UserData moderator) {
        this.moderator = moderator;
    }

    public void setCreator(UserData creator) {
        this.creator = creator;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setType(ReviewType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public UserData getAuthor() {
        return this.author;
    }

    public UserData getModerator() {
        return this.moderator;
    }

    public UserData getCreator() {
        return this.creator;
    }

    public PermId<ReviewData> getPermaId() {
        return new PermId<ReviewData>(this.permaId);
    }

    public void setPermaId(PermId<ReviewData> permId) {
        this.permaId = permId.getId();
    }

    public Set<String> getPermaIdHistory() {
        return this.permaIdHistory;
    }

    public void setPermaIdHistory(Set<String> permaIdHistory) {
        this.permaIdHistory = permaIdHistory;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setPermaIdAsString(String permaId) {
        this.permaId = permaId;
    }

    public String getName() {
        return this.name;
    }

    public State getState() {
        return this.state;
    }

    public ReviewType getType() {
        return this.type;
    }

    public Boolean isAllowReviewersToJoin() {
        return this.allowReviewersToJoin;
    }

    public void setAllowReviewersToJoin(Boolean allowReviewersToJoin) {
        this.allowReviewersToJoin = allowReviewersToJoin;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public PermId<ReviewData> getParentReview() {
        return this.parentReview;
    }

    public void setParentReview(PermId<ReviewData> parentReview) {
        this.parentReview = parentReview;
    }

    public int getMetricsVersion() {
        return this.metricsVersion;
    }

    public void setMetricsVersion(int metricsVersion) {
        this.metricsVersion = metricsVersion;
    }

    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    public Date getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
    }

    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    public Date getReminderDate() {
        return this.reminderDate;
    }

    public void setReminderDate(Date reminderDate) {
        this.reminderDate = reminderDate;
    }

    public String getJiraIssueKey() {
        return this.jiraIssueKey;
    }

    public void setJiraIssueKey(String jiraIssueKey) {
        this.jiraIssueKey = jiraIssueKey;
    }

    public static enum ReviewType {
        REVIEW,
        SNIPPET;

    }

    public static enum State {
        Draft,
        Approval,
        Review,
        Summarize,
        Closed,
        Dead,
        Rejected,
        Unknown,
        OpenSnippet,
        ClosedSnippet;

    }

    @XmlTransient
    public static class Builder {
        private final ReviewData reviewData;

        public Builder() {
            this.reviewData = new ReviewData();
        }

        protected Builder(ReviewData reviewData) {
            this.reviewData = reviewData;
        }

        public ReviewData build() {
            return new ReviewData(this.reviewData);
        }

        public Builder setType(ReviewType reviewType) {
            this.reviewData.setType(reviewType);
            return this;
        }

        public Builder setAllowReviewersToJoin(Boolean allowReviewersToJoin) {
            this.reviewData.setAllowReviewersToJoin(allowReviewersToJoin);
            return this;
        }

        public Builder setAuthor(UserData author) {
            this.reviewData.setAuthor(author);
            return this;
        }

        public Builder setCloseDate(Date closeDate) {
            this.reviewData.setCloseDate(closeDate);
            return this;
        }

        public Builder setCreateDate(Date createDate) {
            this.reviewData.setCreateDate(createDate);
            return this;
        }

        public Builder setCreator(UserData creator) {
            this.reviewData.setCreator(creator);
            return this;
        }

        public Builder setDescription(String description) {
            this.reviewData.setDescription(description);
            return this;
        }

        public Builder setDueDate(Date dueDate) {
            this.reviewData.setDueDate(dueDate);
            return this;
        }

        public Builder setReminderDate(Date dueDate) {
            this.reviewData.setReminderDate(dueDate);
            return this;
        }

        public Builder setJiraIssueKey(String jiraIssueKey) {
            this.reviewData.setJiraIssueKey(jiraIssueKey);
            return this;
        }

        public Builder setMetricsVersion(int metricsVersion) {
            this.reviewData.setMetricsVersion(metricsVersion);
            return this;
        }

        public Builder setModerator(UserData moderator) {
            this.reviewData.setModerator(moderator);
            return this;
        }

        public Builder setName(String name) {
            this.reviewData.setName(name);
            return this;
        }

        public Builder setParentReview(PermId<ReviewData> parentReview) {
            this.reviewData.setParentReview(parentReview);
            return this;
        }

        public Builder setPermaId(String permaId) {
            this.reviewData.setPermaIdAsString(permaId);
            return this;
        }

        public Builder setPermaIdHistory(Set<String> permaIdHistory) {
            this.reviewData.setPermaIdHistory(permaIdHistory);
            return this;
        }

        public Builder setProjectKey(String projectKey) {
            this.reviewData.setProjectKey(projectKey);
            return this;
        }

        public Builder setState(State state) {
            this.reviewData.setState(state);
            return this;
        }

        public Builder setSummary(String summary) {
            this.reviewData.setSummary(summary);
            return this;
        }
    }
}

