/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.data;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.bind.annotation.XmlTransient;

@ParametersAreNonnullByDefault
public class RepositoryDataSearchCriteria {
    @Nullable
    private String nameFilter;
    @Nonnull
    private Set<String> typeFilter;
    @Nullable
    private Boolean enabledFilter;
    @Nullable
    private Boolean availableFilter;

    public RepositoryDataSearchCriteria() {
    }

    private RepositoryDataSearchCriteria(@Nullable String nameFilter, Set<String> typeFilter, @Nullable Boolean enabledFilter, @Nullable Boolean availableFilter) {
        this.nameFilter = nameFilter;
        this.typeFilter = (Set)Preconditions.checkNotNull(typeFilter, (Object)"typeFilter");
        this.enabledFilter = enabledFilter;
        this.availableFilter = availableFilter;
    }

    @Nullable
    public String getNameFilter() {
        return this.nameFilter;
    }

    @Nonnull
    public Set<String> getTypeFilter() {
        return this.typeFilter;
    }

    @Nullable
    public Boolean getEnabledFilter() {
        return this.enabledFilter;
    }

    @Nullable
    public Boolean getAvailableFilter() {
        return this.availableFilter;
    }

    @XmlTransient
    public static class Builder {
        private String nameFilter;
        private Set<String> typeFilter = Collections.emptySet();
        private Boolean enabledFilter;
        private Boolean availableFilter;

        public Builder setNameFilter(@Nullable String nameFilter) {
            this.nameFilter = nameFilter;
            return this;
        }

        public Builder setTypeFilter(Set<String> typeFilter) {
            this.typeFilter = (Set)Preconditions.checkNotNull(typeFilter, (Object)"typeFilter");
            return this;
        }

        public Builder setEnabledFilter(@Nullable Boolean enabledFilter) {
            this.enabledFilter = enabledFilter;
            return this;
        }

        public Builder setAvailableFilter(@Nullable Boolean runningFilter) {
            this.availableFilter = runningFilter;
            return this;
        }

        public RepositoryDataSearchCriteria build() {
            return new RepositoryDataSearchCriteria(this.nameFilter, this.typeFilter, this.enabledFilter, this.availableFilter);
        }
    }
}

