/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache;

import com.atlassian.cache.StatisticsType;
import com.atlassian.util.concurrent.Assertions;
import java.util.Comparator;
import javax.annotation.Nonnull;

public enum CacheStatisticsKey {
    SIZE("size", StatisticsType.GAUGE),
    HEAP_SIZE("heapSize", StatisticsType.GAUGE),
    HIT_COUNT("hitCount", StatisticsType.COUNTER),
    PUT_COUNT("putCount", StatisticsType.COUNTER),
    REMOVE_COUNT("removeCount", StatisticsType.COUNTER),
    MISS_COUNT("missCount", StatisticsType.COUNTER),
    TOTAL_MISS_TIME("totalMissTime", StatisticsType.COUNTER),
    EVICTION_COUNT("evictionCount", StatisticsType.COUNTER);

    public static Comparator<CacheStatisticsKey> SORT_BY_LABEL;
    private final String label;
    private final StatisticsType type;

    private CacheStatisticsKey(String label, StatisticsType type) {
        this.label = (String)Assertions.notNull((String)"label", (Object)label);
        this.type = (StatisticsType)((Object)Assertions.notNull((String)"type", (Object)((Object)type)));
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public StatisticsType getType() {
        return this.type;
    }

    static {
        SORT_BY_LABEL = new Comparator<CacheStatisticsKey>(){

            @Override
            public int compare(CacheStatisticsKey key1, CacheStatisticsKey key2) {
                return key1.getLabel().compareTo(key2.getLabel());
            }
        };
    }
}

