/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4;

import com.atlassian.crowd.util.persistence.hibernate.batch.AbstractBatchProcessor;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hibernate4BatchProcessor
extends AbstractBatchProcessor<Session> {
    private static final ThreadLocal<Session> currentSessionHolder = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(Hibernate4BatchProcessor.class);
    private final SessionFactory sessionFactory;

    public Hibernate4BatchProcessor(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Session getSession() {
        return currentSessionHolder.get();
    }

    protected void afterProcessBatch() {
        this.commitTransaction();
    }

    protected void afterProcessCollection() {
        this.closeSession();
    }

    protected void afterProcessIndividual() {
        this.commitTransaction();
    }

    protected void beforeProcessBatch() {
        this.startTransaction();
    }

    protected void beforeProcessCollection() {
        this.openSession();
    }

    protected void beforeProcessIndividual() {
        this.startTransaction();
    }

    protected void commitTransaction() {
        this.flushSession();
        Transaction transaction = this.getSession().getTransaction();
        log.debug("commit transaction [ {} ]", (Object)transaction);
        transaction.commit();
        this.clearSession();
    }

    protected void rollbackProcessBatch() {
        this.rollbackTransaction();
    }

    protected void rollbackProcessIndividual() {
        this.rollbackTransaction();
    }

    protected void rollbackTransaction() {
        Transaction transaction = this.getSession().getTransaction();
        transaction.rollback();
        log.debug("rollback transaction [ {} ]", (Object)transaction);
        this.clearSession();
    }

    protected void startTransaction() {
        Transaction transaction = this.getSession().beginTransaction();
        log.debug("start transaction [ {} ]", (Object)transaction);
    }

    private void clearSession() {
        Session session = this.getSession();
        if (session != null) {
            log.debug("clear session [{}]", (Object)session);
            session.clear();
        }
    }

    private void closeSession() {
        if (currentSessionHolder.get() != null) {
            log.debug("close session [{}]", (Object)currentSessionHolder.get());
            currentSessionHolder.get().close();
            currentSessionHolder.set(null);
        }
    }

    private void flushSession() {
        Session session = this.getSession();
        if (session != null) {
            log.debug("flush session [{}]", (Object)session);
            session.flush();
        }
    }

    private Session openSession() {
        if (currentSessionHolder.get() != null) {
            throw new IllegalStateException("session already open");
        }
        Session session = this.sessionFactory.openSession();
        session.setFlushMode(FlushMode.MANUAL);
        session.setCacheMode(CacheMode.IGNORE);
        currentSessionHolder.set(session);
        log.debug("open new session [{}]", (Object)currentSessionHolder.get());
        return session;
    }
}

