/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.util.persistence.hibernate.batch.AbstractBatchFinder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class Hibernate4BatchFinder
extends AbstractBatchFinder {
    private static final ThreadLocal<Session> currentSessionHolder = new ThreadLocal();
    private final SessionFactory sessionFactory;

    public Hibernate4BatchFinder(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected void afterFind() {
        currentSessionHolder.get().close();
        currentSessionHolder.set(null);
    }

    protected void beforeFind() {
        currentSessionHolder.set(this.sessionFactory.openSession());
    }

    protected <E> Collection<E> processBatchFind(long directoryID, Collection<String> names, Class<E> persistentClass) {
        ImmutableList lowercaseNames = ImmutableList.copyOf((Iterable)Iterables.transform(names, (Function)IdentifierUtils.TO_LOWER_CASE));
        return CriteriaFactory.createCriteria(currentSessionHolder.get(), persistentClass).add((Criterion)Restrictions.eq((String)"directory.id", (Object)directoryID)).add(Restrictions.in((String)"lowerName", (Collection)lowercaseNames)).list();
    }
}

