/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.crowd.util.persistence.hibernate.MappingResources;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaHelper {
    private static final Logger logger = LoggerFactory.getLogger(SchemaHelper.class);
    public static final String COMPONENT_REFERENCE = "schemaHelper";
    private Configuration configuration;
    private HibernateConfig hibernateConfig;
    private Properties hibernateConfigProperties;
    private MappingResources mappingResources;

    public Configuration getConfiguration() throws MappingException {
        if (this.configuration == null) {
            this.configuration = this.makeBaseHibernateConfiguration();
            if (this.mappingResources != null) {
                int n = this.mappingResources.getMappings().size();
                for (int i = 0; i < n; ++i) {
                    this.configuration.addResource(this.mappingResources.getMappings().get(i), Thread.currentThread().getContextClassLoader());
                }
            }
        }
        return this.configuration;
    }

    public MappingResources getMappingResources() {
        return this.mappingResources;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public void setHibernateProperties(Properties props) {
        this.hibernateConfigProperties = props;
    }

    public void setMappingResources(MappingResources mappings) {
        this.mappingResources = mappings;
    }

    public void updateSchemaIfNeeded() throws ConfigurationException {
        this.updateSchemaIfNeeded(true);
    }

    public void updateSchemaIfNeeded(boolean showDDL) throws ConfigurationException {
        try {
            new SchemaUpdate(this.getConfiguration()).execute(showDDL, true);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    private Configuration makeBaseHibernateConfiguration() {
        if (this.hibernateConfigProperties != null) {
            return new Configuration().setProperties(this.hibernateConfigProperties);
        }
        return new Configuration().setProperties(this.hibernateConfig.getHibernateProperties());
    }

    public void createSchema() throws ConfigurationException {
        try {
            SchemaExport schemaExport = new SchemaExport(this.getConfiguration());
            schemaExport.drop(logger.isDebugEnabled(), true);
            schemaExport.create(logger.isDebugEnabled(), true);
        }
        catch (MappingException e) {
            logger.error("While creating the database schema", (Throwable)e);
            throw new ConfigurationException("Error dropping and creating database schema: " + e.getMessage(), (Throwable)e);
        }
        catch (HibernateException e) {
            logger.error("While creating the database schema", (Throwable)e);
            throw new ConfigurationException("Error dropping and creating database schema: " + e.getMessage(), (Throwable)e);
        }
    }
}

