/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.crowd.util.persistence.hibernate.TransparentConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class MappingResources
implements InitializingBean {
    private Resource configLocation;
    private List<String> mappings = new ArrayList<String>();
    private List<String> tableNames;

    public void addMapping(String mapping) {
        this.mappings.add(mapping);
    }

    public void afterPropertiesSet() throws IllegalStateException, IOException {
        TransparentConfiguration config = new TransparentConfiguration();
        if (this.configLocation != null) {
            config.configure(this.configLocation.getURL());
            this.mappings = config.getMappingFiles();
        } else if (this.mappings != null) {
            for (String hbmFile : this.mappings) {
                config.addResource(hbmFile);
            }
        }
        config.buildMappings();
        if (this.mappings == null || this.mappings.isEmpty()) {
            throw new IllegalStateException("Misconfigured mappings/configLocation property on MappingResources bean: no hbm.xml mappings found.");
        }
        this.tableNames = new ArrayList<String>(config.getTables().keySet());
    }

    public Resource getConfigLocation() {
        return this.configLocation;
    }

    public List<String> getMappings() {
        return this.mappings;
    }

    public String[] getMappingsAsArray() {
        String[] map = new String[this.mappings.size()];
        for (int i = 0; i < this.mappings.size(); ++i) {
            map[i] = this.mappings.get(i);
        }
        return map;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setMappings(List<String> mappings) {
        this.mappings.addAll(mappings);
    }
}

