/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchFinder;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ListIterator;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;

public abstract class HibernateDao {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BatchFinder batchFinder;
    protected BatchProcessor<Session> batchProcessor;
    protected SessionFactory sessionFactory;

    public abstract Class getPersistentClass();

    public <T> T load(Class<T> persistentClass, long id) throws ObjectNotFoundException {
        T obj = persistentClass.cast(this.session().get(persistentClass, (Serializable)Long.valueOf(id)));
        if (obj == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)id);
        }
        this.logger.trace("Loaded object: {}", obj);
        return obj;
    }

    public Object load(long id) throws ObjectNotFoundException {
        return this.load(this.getPersistentClass(), id);
    }

    public <T> T loadReference(Class<T> persistentClass, long id) {
        return persistentClass.cast(this.session().load(persistentClass, (Serializable)Long.valueOf(id)));
    }

    public Object loadReference(long id) {
        return this.loadReference(this.getPersistentClass(), id);
    }

    public void remove(Object persistentObject) throws DataAccessException {
        this.logger.debug("Deleting object: {}", persistentObject);
        this.session().delete(persistentObject);
    }

    public void save(Object persistentObject) throws DataAccessException {
        this.logger.debug("Saving object: {}", persistentObject);
        this.session().save(persistentObject);
    }

    public void saveOrUpdate(Object persistentObject) throws DataAccessException {
        this.logger.debug("Saving or updating object: {}", persistentObject);
        this.session().saveOrUpdate(persistentObject);
    }

    @Autowired
    public void setBatchFinder(BatchFinder batchFinder) {
        this.batchFinder = batchFinder;
    }

    @Autowired
    public void setBatchProcessor(BatchProcessor batchProcessor) {
        this.batchProcessor = batchProcessor;
    }

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void update(Object persistentObject) throws DataAccessException {
        this.logger.debug("Updating object: {}", persistentObject);
        this.session().saveOrUpdate(persistentObject);
    }

    protected Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    @SuppressFBWarnings(value={"SQL_INJECTION"}, justification="This gets used all over the place to run queries and we assume that at this point hqlQuery is safe")
    protected org.hibernate.Query createHibernateQuery(Query crowdQuery, HQLQuery hqlQuery) {
        org.hibernate.Query hibernateQuery = this.session().createQuery(hqlQuery.toString()).setFirstResult(crowdQuery.getStartIndex());
        if (crowdQuery.getMaxResults() != -1) {
            hibernateQuery.setMaxResults(crowdQuery.getMaxResults());
        }
        ListIterator iterator = hqlQuery.getParameterValues().listIterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            hibernateQuery.setParameter(HibernateDao.generatedJpaParameterNameForListIndex(iterator), value);
        }
        return hibernateQuery;
    }

    private static String generatedJpaParameterNameForListIndex(ListIterator iterator) {
        return Integer.toString(iterator.nextIndex());
    }
}

