/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.config.db.HibernateConfig;
import com.atlassian.crowd.util.persistence.hibernate.EhCacheProvider;
import com.atlassian.crowd.util.persistence.hibernate.MappingResources;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;
import org.springframework.orm.hibernate4.LocalSessionFactoryBuilder;

public class ConfigurableLocalSessionFactoryBean
extends LocalSessionFactoryBean {
    private CacheManager cacheManager;
    private Map<String, Object> eventListeners;
    private HibernateConfig hibernateConfig;
    private MappingResources mappingResourcesBean;

    public void afterPropertiesSet() throws IOException {
        this.setConfigLocations(null);
        if (this.hibernateConfig != null) {
            this.getHibernateProperties().putAll((Map<?, ?>)this.hibernateConfig.getHibernateProperties());
        }
        if (this.cacheManager != null) {
            this.getHibernateProperties().put(EhCacheProvider.PROP_CACHE_MANAGER, this.cacheManager);
        }
        super.setMappingResources(this.mappingResourcesBean.getMappingsAsArray());
        super.afterPropertiesSet();
    }

    protected SessionFactory buildSessionFactory(LocalSessionFactoryBuilder sfb) {
        SessionFactory sessionFactory = super.buildSessionFactory(sfb);
        this.registerEventListeners((SessionFactoryImplementor)sessionFactory);
        return sessionFactory;
    }

    private void registerEventListeners(SessionFactoryImplementor sessionFactory) {
        if (this.eventListeners != null && !this.eventListeners.isEmpty()) {
            ServiceRegistryImplementor registry = sessionFactory.getServiceRegistry();
            EventListenerRegistry listeners = (EventListenerRegistry)registry.getService(EventListenerRegistry.class);
            for (Map.Entry<String, Object> entry : this.eventListeners.entrySet()) {
                EventType type = EventType.resolveEventTypeByName((String)entry.getKey());
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    listeners.setListeners(type, ((Collection)value).toArray());
                    continue;
                }
                listeners.setListeners(type, new Object[]{value});
            }
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setEventListeners(Map<String, Object> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public void setMappingResourcesBean(MappingResources mappingResourcesBean) {
        this.mappingResourcesBean = mappingResourcesBean;
    }
}

