/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.webhook;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.webhook.WebhookDAO;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.WebhookNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.webhook.Webhook;
import com.atlassian.crowd.model.webhook.WebhookImpl;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class WebhookDAOHibernate
extends HibernateDao
implements WebhookDAO {
    public Webhook findById(Long webhookId) throws WebhookNotFoundException {
        try {
            return (WebhookImpl)this.load(webhookId);
        }
        catch (ObjectNotFoundException e) {
            throw new WebhookNotFoundException(webhookId.longValue());
        }
    }

    public Webhook findByApplicationAndEndpointUrl(Application application, String endpointUrl) throws WebhookNotFoundException {
        Object result = CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"application", (Object)application)).add((Criterion)Restrictions.eq((String)"endpointUrl", (Object)endpointUrl)).uniqueResult();
        if (result == null) {
            throw new WebhookNotFoundException(application.getId().longValue(), endpointUrl);
        }
        return (WebhookImpl)result;
    }

    public Webhook add(Webhook webhook) {
        WebhookImpl webhookToPersist = new WebhookImpl(webhook);
        super.save(webhookToPersist);
        return webhookToPersist;
    }

    public void remove(Webhook webhook) throws WebhookNotFoundException {
        Webhook persistentInstance = this.findById(webhook.getId());
        super.remove(persistentInstance);
    }

    public Iterable<Webhook> findAll() {
        return this.session().createQuery("from WebhookImpl").list();
    }

    public Webhook update(Webhook webhook) throws WebhookNotFoundException {
        try {
            WebhookImpl webhookToUpdate = (WebhookImpl)this.load(webhook.getId());
            webhookToUpdate.updateDetailsFrom(webhook);
            super.update(webhookToUpdate);
            return webhookToUpdate;
        }
        catch (ObjectNotFoundException e) {
            throw new WebhookNotFoundException(webhook.getId().longValue());
        }
    }

    @Override
    public Class getPersistentClass() {
        return WebhookImpl.class;
    }
}

