/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.user;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.InternalAttributesHelper;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.user.InternalUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.InternalEntityUtils;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4.operation.MergeOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4.operation.RemoveUserOperation;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class UserDAOHibernate
extends HibernateDao
implements InternalUserDao,
UserDao {
    public static final String EXTERNAL_ID = "externalId";
    public static final String DIRECTORY_ID = "directory.id";
    private InternalAttributesHelper attributesHelper;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalMembershipDao membershipDao;

    public InternalUser add(User user, PasswordCredential credential) throws DirectoryNotFoundException, UserAlreadyExistsException {
        InternalUser existingUser = this.findByNameInternal(user.getDirectoryId(), user.getName());
        if (existingUser != null) {
            throw new UserAlreadyExistsException(existingUser.getDirectoryId(), existingUser.getName());
        }
        InternalUser userToAdd = new InternalUser(user, (Directory)this.getDirectory(user), credential);
        userToAdd.setCreatedDateToNow();
        userToAdd.setUpdatedDateToNow();
        super.save(userToAdd);
        return userToAdd;
    }

    public BatchResult<User> addAll(Set<UserTemplateWithCredentialAndAttributes> users) {
        HashSet<TransactionGroup> usersToAdd = new HashSet<TransactionGroup>();
        HashSet<UserTemplateWithCredentialAndAttributes> usersFailedValidation = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                InternalUser userToAdd = new InternalUser((User)user, (Directory)this.getDirectory((User)user), user.getCredential());
                userToAdd.setCreatedDateToNow();
                userToAdd.setUpdatedDateToNow();
                HashSet<InternalUserAttribute> attribs = new HashSet<InternalUserAttribute>();
                for (Map.Entry entry : user.getAttributes().entrySet()) {
                    for (String value : (Set)entry.getValue()) {
                        attribs.add(new InternalUserAttribute(userToAdd, (String)entry.getKey(), value));
                    }
                }
                usersToAdd.add(new TransactionGroup((Serializable)userToAdd, attribs));
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Could not add user <" + user.getName() + ">: " + e.getMessage());
                usersFailedValidation.add(user);
            }
            catch (DirectoryNotFoundException e) {
                this.logger.error("Could not add user <" + user.getName() + ">: " + e.getMessage());
                usersFailedValidation.add(user);
            }
        }
        BatchResult daoResult = this.batchProcessor.execute((HibernateOperation)new MergeOperation(), usersToAdd);
        BatchResult result = new BatchResult(users.size());
        for (TransactionGroup transactionGroup : daoResult.getSuccessfulEntities()) {
            result.addSuccess((Object)transactionGroup.getPrimaryObject());
        }
        for (TransactionGroup transactionGroup : daoResult.getFailedEntities()) {
            result.addFailure((Object)transactionGroup.getPrimaryObject());
        }
        result.addFailures(usersFailedValidation);
        return result;
    }

    public BatchResultWithIdReferences<User> addAll(Collection<UserTemplateWithCredentialAndAttributes> users) {
        HashSet<TransactionGroup> usersToAdd = new HashSet<TransactionGroup>();
        HashSet<UserTemplateWithCredentialAndAttributes> usersFailedValidation = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                DirectoryImpl directory = this.loadReference(DirectoryImpl.class, user.getDirectoryId());
                InternalUser userToAdd = new InternalUser(user, (Directory)directory);
                HashSet<InternalUserAttribute> attribs = new HashSet<InternalUserAttribute>();
                for (Map.Entry entry : user.getAttributes().entrySet()) {
                    for (String value : (Set)entry.getValue()) {
                        attribs.add(new InternalUserAttribute(userToAdd, (String)entry.getKey(), value));
                    }
                }
                usersToAdd.add(new TransactionGroup((Serializable)userToAdd, attribs));
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Could not add user <" + user.getName() + ">: " + e.getMessage());
                usersFailedValidation.add(user);
            }
        }
        BatchResult daoResult = this.batchProcessor.execute((HibernateOperation)new MergeOperation(), usersToAdd);
        BatchResultWithIdReferences result = new BatchResultWithIdReferences(users.size());
        for (TransactionGroup transactionGroup : daoResult.getFailedEntities()) {
            result.addFailure((Object)transactionGroup.getPrimaryObject());
        }
        result.addFailures(usersFailedValidation);
        for (TransactionGroup user : usersToAdd) {
            result.addIdReference((InternalDirectoryEntity)user.getPrimaryObject());
        }
        return result;
    }

    public InternalUser findByName(long directoryId, String username) throws UserNotFoundException {
        InternalUser user = this.findByNameInternal(directoryId, username);
        if (user == null) {
            throw new UserNotFoundException(username);
        }
        return user;
    }

    public InternalUser findByExternalId(long directoryId, String externalId) throws UserNotFoundException {
        Preconditions.checkNotNull((Object)externalId, (Object)EXTERNAL_ID);
        InternalUser user = (InternalUser)CriteriaFactory.createCriteria(this.session(), InternalUser.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add((Criterion)Restrictions.eq((String)EXTERNAL_ID, (Object)externalId)).uniqueResult();
        if (user == null) {
            UserNotFoundException.throwNotFoundByExternalId((String)externalId);
        }
        return user;
    }

    public InternalUserWithAttributes findByNameWithAttributes(long directoryId, String username) throws UserNotFoundException {
        InternalUser user = this.findByName(directoryId, username);
        Set<InternalUserAttribute> attributesList = this.findUserAttributes(user.getId());
        Map attributesMap = this.attributesHelper.attributesListToMap(attributesList);
        return new InternalUserWithAttributes(user, attributesMap);
    }

    public Collection<InternalUser> findByNames(long directoryID, Collection<String> usernames) {
        return this.batchFinder.find(directoryID, usernames, InternalUser.class);
    }

    public Set<InternalUserAttribute> findUserAttributes(long userID) {
        return Sets.newHashSet((Iterable)CriteriaFactory.createCriteria(this.session(), InternalUserAttribute.class).add((Criterion)Restrictions.eq((String)"user.id", (Object)userID)).list());
    }

    public PasswordCredential getCredential(long directoryId, String username) throws UserNotFoundException {
        return this.findByName(directoryId, username).getCredential();
    }

    public List<PasswordCredential> getCredentialHistory(long directoryId, String username) throws UserNotFoundException {
        return this.findByName(directoryId, username).getCredentialHistory();
    }

    @Override
    public Class getPersistentClass() {
        return InternalUser.class;
    }

    public void remove(User user) throws UserNotFoundException {
        InternalUser userToRemove = this.findByName(user.getDirectoryId(), user.getName());
        this.membershipDao.removeUserMemberships(user.getDirectoryId(), user.getName());
        this.session().getNamedQuery("removeAllInternalUserAttributes").setEntity("user", (Object)userToRemove).executeUpdate();
        super.remove(userToRemove);
    }

    public void removeAll(long directoryId) {
        this.membershipDao.removeAllUserRelationships(directoryId);
        this.session().getNamedQuery("removeInternalUserAttributesInDirectory").setLong("directoryId", directoryId).executeUpdate();
        this.session().getNamedQuery("removeCredentialRecordsInDirectory").setLong("directoryId", directoryId).executeUpdate();
        this.session().getNamedQuery("removeInternalUsersInDirectory").setLong("directoryId", directoryId).executeUpdate();
    }

    public BatchResult<String> removeAllUsers(long directoryId, Set<String> userNames) {
        Collection<InternalUser> users = this.findByNames(directoryId, userNames);
        BatchResult batchResult = this.batchProcessor.execute((HibernateOperation)new RemoveUserOperation(), users);
        BatchResult overallResult = new BatchResult(userNames.size());
        overallResult.addFailures(Collections2.transform((Collection)batchResult.getFailedEntities(), (Function)InternalEntityUtils.GET_NAME));
        overallResult.addSuccesses(Collections2.transform((Collection)batchResult.getSuccessfulEntities(), (Function)InternalEntityUtils.GET_NAME));
        return overallResult;
    }

    @Nonnull
    public Set<String> getAllExternalIds(long directoryId) throws DirectoryNotFoundException {
        this.getDirectory(directoryId);
        return ImmutableSet.copyOf((Collection)CriteriaFactory.createCriteria(this.session(), InternalUser.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add(Restrictions.isNotNull((String)EXTERNAL_ID)).setProjection((Projection)Projections.property((String)EXTERNAL_ID)).list());
    }

    public long getUserCount(long directoryId) throws DirectoryNotFoundException {
        this.getDirectory(directoryId);
        return ((Number)CriteriaFactory.createCriteria(this.session(), InternalUser.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).setProjection(Projections.rowCount()).uniqueResult()).longValue();
    }

    public void removeAttribute(User user, String attributeName) throws UserNotFoundException {
        this.removeAttributes(this.findByName(user.getDirectoryId(), user.getName()), attributeName);
    }

    public InternalUser rename(User user, String newUsername) throws UserNotFoundException, UserAlreadyExistsException {
        InternalUser userToRename = this.findByName(user.getDirectoryId(), user.getName());
        if (newUsername.equals(userToRename.getName())) {
            return userToRename;
        }
        String oldName = userToRename.getName();
        InternalUser existingUser = this.findByNameInternal(user.getDirectoryId(), newUsername);
        if (existingUser != null && !userToRename.getId().equals(existingUser.getId())) {
            throw new UserAlreadyExistsException(existingUser.getDirectoryId(), existingUser.getName());
        }
        userToRename.renameTo(newUsername);
        userToRename.setUpdatedDateToNow();
        super.update(userToRename);
        this.membershipDao.renameUserRelationships(userToRename.getDirectoryId(), oldName, userToRename.getName());
        return userToRename;
    }

    public <T> List<T> search(long directoryID, EntityQuery<T> query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.USER) {
            throw new IllegalArgumentException("UserDAO can only evaluate EntityQueries for Entity.USER");
        }
        HQLQuery hqlQuery = this.hqlQueryTranslater.asHQL(directoryID, query);
        org.hibernate.Query hibernateQuery = this.createHibernateQuery((Query)query, hqlQuery);
        return HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
    }

    @Autowired
    public void setAttributesHelper(InternalAttributesHelper attributesHelper) {
        this.attributesHelper = attributesHelper;
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    @Autowired
    public void setMembershipDao(InternalMembershipDao internalMembershipDao) {
        this.membershipDao = internalMembershipDao;
    }

    public void storeAttributes(User user, Map<String, Set<String>> attributes) throws UserNotFoundException {
        InternalUser internalUser = this.findByName(user.getDirectoryId(), user.getName());
        Set<InternalUserAttribute> attributesList = this.findUserAttributes(internalUser.getId());
        HashMap<String, HashSet<InternalUserAttribute>> existingAttributesMap = new HashMap<String, HashSet<InternalUserAttribute>>();
        for (InternalUserAttribute internalUserAttribute : attributesList) {
            HashSet<InternalUserAttribute> existingVals = (HashSet<InternalUserAttribute>)existingAttributesMap.get(internalUserAttribute.getName());
            if (existingVals == null) {
                existingVals = new HashSet<InternalUserAttribute>();
                existingAttributesMap.put(internalUserAttribute.getName(), existingVals);
            }
            existingVals.add(internalUserAttribute);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            if (existingAttributesMap.containsKey(entry.getKey())) {
                Set newVals = (Set)entry.getValue();
                Set existingVals = (Set)existingAttributesMap.get(entry.getKey());
                ArrayList<String> valsToAdd = new ArrayList<String>();
                HashSet valsToRemove = new HashSet(existingVals);
                for (String newVal : newVals) {
                    boolean valueAlreadyExists = false;
                    for (InternalUserAttribute existingVal : existingVals) {
                        if (!newVal.equals(existingVal.getValue())) continue;
                        valsToRemove.remove(existingVal);
                        valueAlreadyExists = true;
                        break;
                    }
                    if (valueAlreadyExists) continue;
                    valsToAdd.add(newVal);
                }
                for (InternalUserAttribute existingVal : valsToRemove) {
                    if (valsToAdd.size() > 0) {
                        String newVal = (String)valsToAdd.remove(0);
                        existingVal.setValue(newVal);
                        this.saveOrUpdate(existingVal);
                        continue;
                    }
                    this.remove(existingVal);
                }
                for (String newVal : valsToAdd) {
                    this.addAttribute(internalUser, (String)entry.getKey(), newVal);
                }
                continue;
            }
            for (String newVal : (Set)entry.getValue()) {
                this.addAttribute(internalUser, (String)entry.getKey(), newVal);
            }
        }
    }

    public InternalUser update(User user) throws UserNotFoundException {
        InternalUser userToUpdate = this.findByName(user.getDirectoryId(), user.getName());
        userToUpdate.updateDetailsFrom(user);
        userToUpdate.setUpdatedDateToNow();
        super.update(userToUpdate);
        return userToUpdate;
    }

    public void updateCredential(User user, PasswordCredential credential, int maxPasswordHistory) throws UserNotFoundException {
        InternalUser userToUpdate = this.findByName(user.getDirectoryId(), user.getName());
        userToUpdate.updateCredentialTo(credential, maxPasswordHistory);
        userToUpdate.setUpdatedDateToNow();
        super.update(userToUpdate);
    }

    private void addAttribute(InternalUser user, String attributeName, String attributeValue) {
        InternalUserAttribute attribute = new InternalUserAttribute(user, attributeName, attributeValue);
        this.session().save((Object)attribute);
        user.getAttributes().add(attribute);
    }

    private void addAttributeWhereMissingInDirectory(long directoryId, String attrName, String value) {
        DetachedCriteria usersWithAttribute = DetachedCriteria.forClass(InternalUserAttribute.class).add((Criterion)Restrictions.eq((String)"name", (Object)attrName)).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).setProjection((Projection)Property.forName((String)"user.id"));
        List users = CriteriaFactory.createCriteria(this.session(), InternalUser.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add(Property.forName((String)"id").notIn(usersWithAttribute)).list();
        for (InternalUser user : users) {
            this.addAttribute(user, attrName, value);
        }
    }

    private void deleteRepeatedAttributeInDirectory(long directoryId, String attrName) {
        this.session().getNamedQuery("deleteRepeatedAttributeInDirectory").setParameter("attrName", (Object)attrName).setParameter("directoryId", (Object)directoryId).executeUpdate();
        this.session().flush();
        this.session().clear();
    }

    public void setAttributeForAllInDirectory(long directoryId, String attrName, String value) {
        this.deleteRepeatedAttributeInDirectory(directoryId, attrName);
        this.session().getNamedQuery("updateAttributeForAllUsersInDirectory").setParameter("value", (Object)value).setParameter("lowerValue", (Object)IdentifierUtils.toLowerCase((String)value)).setParameter("attrName", (Object)attrName).setParameter("directoryId", (Object)directoryId).executeUpdate();
        this.session().flush();
        this.session().clear();
        this.addAttributeWhereMissingInDirectory(directoryId, attrName, value);
    }

    private InternalUser findByNameInternal(long directoryId, String username) {
        return (InternalUser)CriteriaFactory.createCriteria(this.session(), InternalUser.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add((Criterion)Restrictions.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)username))).uniqueResult();
    }

    private DirectoryImpl getDirectory(User user) throws DirectoryNotFoundException {
        Validate.notNull((Object)user.getDirectoryId(), (String)"Cannot add user with null directoryId", (Object[])new Object[0]);
        return this.getDirectory(user.getDirectoryId());
    }

    private DirectoryImpl getDirectory(long directoryId) throws DirectoryNotFoundException {
        try {
            return this.load(DirectoryImpl.class, directoryId);
        }
        catch (ObjectNotFoundException e) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId), (Throwable)e);
        }
    }

    private void removeAttributes(InternalUser user, String attributeName) {
        this.session().getNamedQuery("removeInternalUserAttributes").setEntity("user", (Object)user).setString("attributeName", attributeName).executeUpdate();
    }
}

