/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.token;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.TokenTermKeys;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataRetrievalFailureException;

public class TokenDAOHibernate
extends HibernateDao
implements TokenDAO {
    private final long lastAccessedTimeUpdateThresholdMillis;
    private final HQLQueryTranslater hqlQueryTranslater;

    public TokenDAOHibernate(HQLQueryTranslater hqlQueryTranslater, long lastAccessedTimeUpdateThresholdMillis) {
        this.lastAccessedTimeUpdateThresholdMillis = lastAccessedTimeUpdateThresholdMillis;
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    public Token add(Token token) throws ObjectAlreadyExistsException {
        this.session().flush();
        try {
            super.save(token);
            this.session().flush();
            return token;
        }
        catch (HibernateException e) {
            throw new ObjectAlreadyExistsException(token.getIdentifierHash());
        }
    }

    public Token findByID(long ID) throws ObjectNotFoundException {
        return (Token)this.load(ID);
    }

    public Token findByIdentifierHash(String identifierHash) throws ObjectNotFoundException {
        Object result = CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"identifierHash", (Object)identifierHash)).uniqueResult();
        if (result == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)identifierHash);
        }
        return (Token)result;
    }

    public Token findByRandomHash(String randomHash) throws ObjectNotFoundException {
        Object result = CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"randomHash", (Object)randomHash)).uniqueResult();
        if (result == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)randomHash);
        }
        return (Token)result;
    }

    @Override
    public Class getPersistentClass() {
        return Token.class;
    }

    public Collection<Token> loadAll() {
        return CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).list();
    }

    public void remove(Token token) {
        this.session().getNamedQuery("removeToken").setEntity("token", (Object)token).executeUpdate();
        this.session().flush();
    }

    public void remove(long directoryId, String name) {
        this.session().getNamedQuery("removeTokensByDirectoryAndName").setLong("directoryId", directoryId).setString("name", name).executeUpdate();
    }

    public void removeExcept(long directoryId, String name, String exclusionToken) {
        BooleanRestriction restriction = Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).exactlyMatching((Object)directoryId), Restriction.on((Property)TokenTermKeys.NAME).exactlyMatching((Object)name)});
        EntityQuery query = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)restriction).startingAt(0).returningAtMost(-1);
        for (Token t : this.search((EntityQuery<? extends Token>)query)) {
            if (t.getRandomHash().equals(exclusionToken)) continue;
            this.remove(t);
        }
    }

    public void removeExpiredTokens(Date currentTime, long maxLifeInSeconds) {
        int removed = this.session().getNamedQuery("removeExpiredTokens").setLong("maxLifeInSeconds", maxLifeInSeconds).setLong("currentTime", currentTime.getTime()).executeUpdate();
        this.logger.debug("removeExpiredTokens removed tokens: {}", (Object)removed);
    }

    public void removeAll(long directoryId) {
        this.session().getNamedQuery("removeTokensByDirectory").setLong("directoryId", directoryId).executeUpdate();
    }

    public void removeAll() {
        int removed = this.session().getNamedQuery("removeAllTokens").executeUpdate();
        this.logger.debug("removeAll removed tokens: {}", (Object)removed);
    }

    public void saveAll(Collection<Token> tokens) {
        if (tokens == null) {
            throw new DataRetrievalFailureException("Unable to save an empty collection of tokens");
        }
        for (Token token : tokens) {
            this.save(token);
        }
    }

    public List<Token> search(EntityQuery<? extends Token> query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.TOKEN) {
            throw new IllegalArgumentException("TokenDAO can only evaluate EntityQueries for Entity.TOKEN");
        }
        HQLQuery hqlQuery = this.hqlQueryTranslater.asHQL(query);
        org.hibernate.Query hibernateQuery = this.createHibernateQuery((Query)query, hqlQuery);
        return HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
    }

    public Token update(Token token) {
        long now = System.currentTimeMillis();
        long diff = now - token.getLastAccessedTime();
        if (diff > this.lastAccessedTimeUpdateThresholdMillis) {
            token.setLastAccessedTime(now);
        }
        super.update(token);
        return token;
    }
}

