/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.token;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.token.ExpirableUserTokenDao;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.model.token.ExpirableUserToken;
import com.atlassian.crowd.model.token.InternalExpirableUserToken;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.fugue.Option;
import java.util.Date;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ExpirableUserTokenDaoHibernate
extends HibernateDao
implements ExpirableUserTokenDao {
    public ExpirableUserToken add(ExpirableUserToken token) throws ObjectAlreadyExistsException {
        try {
            this.session().save((Object)token);
            return token;
        }
        catch (HibernateException e) {
            throw new ObjectAlreadyExistsException(token.getToken());
        }
    }

    public Option<ExpirableUserToken> findByToken(String token) {
        Object result = CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"token", (Object)token)).uniqueResult();
        return Option.option((Object)((ExpirableUserToken)result));
    }

    public boolean removeByToken(String token) {
        int numDeleted = this.session().getNamedQuery("removeExpirableUserToken").setString("token", token).executeUpdate();
        return numDeleted > 0;
    }

    public boolean removeExpiredTokens(Date cutoffDate) {
        int numDeleted = this.session().getNamedQuery("removeExpiredUserTokens").setLong("date", cutoffDate.getTime()).executeUpdate();
        return numDeleted > 0;
    }

    public boolean removeByDirectoryAndUsername(long directoryId, String username) {
        int numDeleted = this.session().getNamedQuery("removeExpirableUserTokensByUsernameAndDirectory").setString("username", username).setLong("directoryId", directoryId).executeUpdate();
        return numDeleted > 0;
    }

    @Override
    public Class getPersistentClass() {
        return InternalExpirableUserToken.class;
    }
}

