/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.property;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.property.PropertyDAO;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.property.PropertyId;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.io.Serializable;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class PropertyDAOHibernate
extends HibernateDao
implements PropertyDAO {
    public Property add(Property property) {
        super.save(property);
        return property;
    }

    public Property find(String key, String name) throws ObjectNotFoundException {
        Object result = this.session().get(this.getPersistentClass(), (Serializable)new PropertyId(key, name));
        if (result == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)name);
        }
        return (Property)result;
    }

    public List<Property> findAll(String key) {
        return CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"propertyId.key", (Object)key)).list();
    }

    public List<Property> findAll() {
        return CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).list();
    }

    @Override
    public Class getPersistentClass() {
        return Property.class;
    }

    public void remove(String key, String name) {
        try {
            Property property = this.find(key, name);
            super.remove(property);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public Property update(Property property) {
        super.update(property);
        return property;
    }
}

