/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.permission;

import com.atlassian.crowd.dao.permission.InternalUserPermissionDAO;
import com.atlassian.crowd.manager.permission.PermittedGroup;
import com.atlassian.crowd.manager.permission.PermittedGroupImpl;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.permission.InternalGrantedPermission;
import com.atlassian.crowd.model.permission.UserPermission;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;

public class UserPermissionDAOHibernate
extends HibernateDao
implements InternalUserPermissionDAO {
    @Override
    public Class getPersistentClass() {
        return InternalGrantedPermission.class;
    }

    public void grant(InternalGrantedPermission permission) {
        Preconditions.checkNotNull((Object)permission.getGroupMapping());
        Preconditions.checkNotNull((Object)permission.getPermission());
        permission.setCreatedDate(new Date());
        this.session().saveOrUpdate((Object)permission);
    }

    public Collection<GroupMapping> getGroupMappingsWithGrantedPermission(UserPermission permission) {
        return this.session().createCriteria(InternalGrantedPermission.class).add((Criterion)Restrictions.eq((String)"permission", (Object)permission)).setProjection((Projection)Projections.property((String)"groupMapping")).list();
    }

    public List<PermittedGroup> findHighestPermissionPerGroupByPrefix(String prefix, int start, int limit) {
        Preconditions.checkNotNull((Object)prefix);
        Criteria criteria = this.buildCriteria(start, limit);
        if (!prefix.isEmpty()) {
            criteria.add(Restrictions.ilike((String)"gm.groupName", (String)prefix, (MatchMode)MatchMode.START));
        }
        return criteria.list();
    }

    public List<PermittedGroup> findHighestPermissionPerGroup(int start, int limit) {
        return this.buildCriteria(start, limit).list();
    }

    private Criteria buildCriteria(int start, int limit) {
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).createAlias("groupMapping", "gm").setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)"groupMapping")).add((Projection)Projections.groupProperty((String)"gm.groupName")).add((Projection)Projections.max((String)"permission"))).setFirstResult(start).addOrder(Order.asc((String)"gm.groupName").ignoreCase()).setResultTransformer((ResultTransformer)new BasicTransformerAdapter(){

            public PermittedGroup transformTuple(Object[] tuple, String[] aliases) {
                GroupMapping groupMapping = (GroupMapping)tuple[0];
                return new PermittedGroupImpl((UserPermission)tuple[2], groupMapping.getDirectory().getId(), groupMapping.getDirectory().getName(), groupMapping.getGroupName());
            }
        });
        if (limit > 0) {
            criteria.setMaxResults(limit);
        }
        return criteria;
    }

    public List<InternalGrantedPermission> findAllPermissionsForGroup(String groupName, long directoryId) {
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).createAlias("groupMapping", "gm").createAlias("gm.directory", "d").addOrder(Order.asc((String)"gm.groupName").ignoreCase()).add((Criterion)Restrictions.eq((String)"gm.groupName", (Object)groupName)).add((Criterion)Restrictions.eq((String)"d.id", (Object)directoryId));
        return criteria.list();
    }

    public List<InternalGrantedPermission> findAllInternalGrantedPermissions() {
        return this.session().createCriteria(InternalGrantedPermission.class).list();
    }

    public boolean revoke(InternalGrantedPermission permission) {
        return this.createRevokeQuery(permission).executeUpdate() > 0;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION"}, justification="Concatenating hardcoded strings only")
    private Query createRevokeQuery(InternalGrantedPermission grantedPermission) {
        Preconditions.checkArgument((grantedPermission.getGroupMapping() != null ? 1 : 0) != 0, (Object)"Group name to revoke must not be empty");
        return this.session().createQuery("delete " + InternalGrantedPermission.class.getSimpleName() + " perm " + "where perm.permission = :permission " + "and perm.groupMapping = :groupMapping").setParameter("permission", (Object)grantedPermission.getPermission()).setParameter("groupMapping", (Object)grantedPermission.getGroupMapping());
    }

    public boolean exists(InternalGrantedPermission grantedPermission) {
        Criteria criteria = this.createHasPermissionEntryCriteria(grantedPermission);
        return (Long)criteria.uniqueResult() > 0L;
    }

    private Criteria createHasPermissionEntryCriteria(InternalGrantedPermission grantedPermission) {
        return this.session().createCriteria(InternalGrantedPermission.class).add((Criterion)Restrictions.eq((String)"permission", (Object)grantedPermission.getPermission())).add((Criterion)Restrictions.eq((String)"groupMapping", (Object)grantedPermission.getGroupMapping())).setProjection((Projection)Projections.count((String)"id"));
    }
}

