/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.membership;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.BoundedCount;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4.operation.MergeOperation;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.springframework.beans.factory.annotation.Autowired;

public class MembershipDAOHibernate
extends HibernateDao
implements MembershipDao,
InternalMembershipDao {
    private InternalGroupDao groupDao;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalUserDao userDao;
    private static final Function<InternalUser, String> LOWERCASE_NAMES_OF_INTERNAL_USERS = new Function<InternalUser, String>(){

        public String apply(InternalUser input) {
            return input.getLowerName();
        }
    };

    public BatchResult<InternalMembership> addAll(Set<InternalMembership> memberships) {
        return this.batchProcessor.execute((HibernateOperation)new MergeOperation(), memberships);
    }

    public BatchResult<String> addAllUsersToGroup(long directoryId, Collection<String> userNames, String groupName) throws GroupNotFoundException {
        Collection internalUsers = this.userDao.findByNames(directoryId, userNames);
        Collection<String> nonFoundUsers = MembershipDAOHibernate.nonFoundUsers(userNames, internalUsers);
        InternalGroup group = this.groupDao.findByName(directoryId, groupName);
        HashSet<InternalMembership> memberships = new HashSet<InternalMembership>();
        for (InternalUser user : internalUsers) {
            memberships.add(new InternalMembership(group, user));
        }
        BatchResult<InternalMembership> daoResult = this.addAll(memberships);
        BatchResult result = new BatchResult(daoResult.getTotalSuccessful());
        for (InternalMembership internalMembership : daoResult.getSuccessfulEntities()) {
            result.addSuccess((Object)internalMembership.getChildName());
        }
        for (InternalMembership internalMembership : daoResult.getFailedEntities()) {
            result.addFailure((Object)internalMembership.getChildName());
        }
        result.addFailures(nonFoundUsers);
        return result;
    }

    private static Collection<String> nonFoundUsers(Collection<String> usernames, Collection<InternalUser> internalUsers) {
        if (internalUsers.size() == usernames.size()) {
            return Collections.emptySet();
        }
        ImmutableSet foundUsernames = ImmutableSet.copyOf((Iterable)Iterables.transform(internalUsers, LOWERCASE_NAMES_OF_INTERNAL_USERS));
        return ImmutableList.copyOf((Iterable)Iterables.filter(usernames, (Predicate)new Predicate<String>((Set)foundUsernames){
            final /* synthetic */ Set val$foundUsernames;
            {
                this.val$foundUsernames = set;
            }

            public boolean apply(String requestedUsername) {
                return !this.val$foundUsernames.contains(IdentifierUtils.toLowerCase((String)requestedUsername));
            }
        }));
    }

    public void addGroupToGroup(long directoryId, String childGroup, String parentGroup) throws GroupNotFoundException, MembershipAlreadyExistsException {
        InternalGroup internalChildGroup = this.groupDao.findByName(directoryId, childGroup);
        InternalGroup internalParentGroup = this.groupDao.findByName(directoryId, parentGroup);
        if (this.isGroupDirectMember(directoryId, childGroup, parentGroup)) {
            throw new MembershipAlreadyExistsException(directoryId, childGroup, parentGroup);
        }
        super.save(new InternalMembership(internalParentGroup, internalChildGroup));
    }

    public void addUserToGroup(long directoryId, String username, String groupName) throws UserNotFoundException, GroupNotFoundException, MembershipAlreadyExistsException {
        InternalUser internalUser = (InternalUser)this.userDao.findByName(directoryId, username);
        InternalGroup internalGroup = this.groupDao.findByName(directoryId, groupName);
        if (this.isUserDirectMember(directoryId, username, groupName)) {
            throw new MembershipAlreadyExistsException(directoryId, username, groupName);
        }
        super.save(new InternalMembership(internalGroup, internalUser));
    }

    public List<InternalMembership> findAll(Collection<Directory> directories) {
        if (directories == null || directories.isEmpty()) {
            return Collections.emptyList();
        }
        return CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add(Restrictions.in((String)"directory", directories)).list();
    }

    public List<InternalMembership> findAllLocal(Collection<Directory> directories) {
        if (directories == null || directories.isEmpty()) {
            return Collections.emptyList();
        }
        return CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add(Restrictions.in((String)"directory", directories)).add(Subqueries.propertyIn((String)"parentId", (DetachedCriteria)DetachedCriteria.forClass(InternalGroup.class).add((Criterion)Restrictions.eq((String)"local", (Object)true)).setProjection((Projection)Projections.id()))).list();
    }

    @Override
    public Class getPersistentClass() {
        return InternalMembership.class;
    }

    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        try {
            this.findInternalMembership(directoryId, childGroup, parentGroup, MembershipType.GROUP_GROUP);
            return true;
        }
        catch (MembershipNotFoundException e) {
            return false;
        }
    }

    public boolean isUserDirectMember(long directoryId, String username, String groupName) {
        try {
            this.findInternalMembership(directoryId, username, groupName, MembershipType.GROUP_USER);
            return true;
        }
        catch (MembershipNotFoundException e) {
            return false;
        }
    }

    public void removeAllRelationships(long directoryId) {
        this.session().getNamedQuery("removeAllRelationships").setLong("directoryId", directoryId).executeUpdate();
    }

    public void removeAllUserRelationships(long directoryId) {
        this.session().getNamedQuery("removeAllRelationshipsOfType").setLong("directoryId", directoryId).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
    }

    public void removeGroupFromGroup(long directoryId, String childGroup, String parentGroup) throws MembershipNotFoundException {
        InternalMembership internalMembership = this.findInternalMembership(directoryId, childGroup, parentGroup, MembershipType.GROUP_GROUP);
        super.remove(internalMembership);
    }

    public void removeGroupMembers(long directoryId, String groupName) {
        this.session().getNamedQuery("removeAllEntityMembers").setString("entityName", IdentifierUtils.toLowerCase((String)groupName)).setLong("directoryId", directoryId).executeUpdate();
    }

    public void removeGroupMemberships(long directoryId, String groupName) {
        this.session().getNamedQuery("removeAllEntityMemberships").setString("entityName", IdentifierUtils.toLowerCase((String)groupName)).setLong("directoryId", directoryId).setParameter("membershipType", (Object)MembershipType.GROUP_GROUP).executeUpdate();
    }

    public void removeUserFromGroup(long directoryId, String username, String groupName) throws UserNotFoundException, GroupNotFoundException, MembershipNotFoundException {
        InternalMembership internalMembership = this.findInternalMembership(directoryId, username, groupName, MembershipType.GROUP_USER);
        super.remove(internalMembership);
    }

    public void removeUserMemberships(long directoryId, String username) {
        this.session().getNamedQuery("removeAllEntityMemberships").setString("entityName", IdentifierUtils.toLowerCase((String)username)).setLong("directoryId", directoryId).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
    }

    public void renameGroupRelationships(long directoryId, String oldName, String newName) {
        this.session().getNamedQuery("renameChild").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter("membershipType", (Object)MembershipType.GROUP_GROUP).executeUpdate();
        this.session().getNamedQuery("renameParent").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter("membershipType", (Object)MembershipType.GROUP_GROUP).executeUpdate();
        this.session().getNamedQuery("renameParent").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
    }

    public void renameUserRelationships(long directoryId, String oldName, String newName) {
        this.session().getNamedQuery("renameChild").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
    }

    public BoundedCount countDirectMembersOfGroup(long directoryId, String groupName, int potentialMaxCount) {
        Number count = (Number)this.session().getNamedQuery("countMembersOfGroup").setLong("directoryId", directoryId).setString("lowerGroupName", IdentifierUtils.toLowerCase((String)groupName)).setParameter("membershipType", (Object)MembershipType.GROUP_USER).uniqueResult();
        return BoundedCount.exactly((long)count.longValue());
    }

    public <T> List<T> search(long directoryId, MembershipQuery<T> query) {
        org.hibernate.Query hibernateQuery = this.createHibernateSearchQuery(directoryId, query);
        return HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
    }

    @Autowired
    public void setGroupDao(InternalGroupDao groupDao) {
        this.groupDao = groupDao;
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    @Autowired
    public void setUserDao(InternalUserDao userDao) {
        this.userDao = userDao;
    }

    protected org.hibernate.Query createHibernateSearchQuery(long directoryId, MembershipQuery<?> query) {
        HQLQuery hqlQuery = this.hqlQueryTranslater.asHQL(directoryId, query);
        return this.createHibernateQuery((Query)query, hqlQuery);
    }

    private InternalMembership findInternalMembership(long directoryId, String childName, String parentName, MembershipType type) throws MembershipNotFoundException {
        InternalMembership internalMembership = (InternalMembership)CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"directory.id", (Object)directoryId)).add((Criterion)Restrictions.eq((String)"lowerParentName", (Object)IdentifierUtils.toLowerCase((String)parentName))).add((Criterion)Restrictions.eq((String)"lowerChildName", (Object)IdentifierUtils.toLowerCase((String)childName))).add((Criterion)Restrictions.eq((String)"membershipType", (Object)type)).uniqueResult();
        if (internalMembership == null) {
            throw new MembershipNotFoundException(childName, parentName);
        }
        return internalMembership;
    }
}

