/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.group;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.model.InternalAttributesHelper;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupAttribute;
import com.atlassian.crowd.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.InternalEntityUtils;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4.operation.MergeOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4.operation.RemoveGroupOperation;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupDAOHibernate
extends HibernateDao
implements InternalGroupDao,
GroupDao {
    private InternalAttributesHelper attributesHelper;
    private DirectoryDao directoryDao;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalMembershipDao membershipDao;

    public InternalGroup add(Group group) throws DirectoryNotFoundException, InvalidGroupException {
        return this.add(group, false);
    }

    public BatchResult<Group> addAll(Set<? extends Group> groups) throws DirectoryNotFoundException {
        HashSet<InternalGroup> groupsToAdd = new HashSet<InternalGroup>();
        HashSet<Group> groupsFailedValidation = new HashSet<Group>();
        for (Group group : groups) {
            try {
                InternalGroup groupToAdd = new InternalGroup(group, this.getDirectory(group));
                groupToAdd.setCreatedDateToNow();
                groupToAdd.setUpdatedDateToNow();
                groupsToAdd.add(groupToAdd);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Could not add group <" + group.getName() + ">: " + e.getMessage());
                groupsFailedValidation.add(group);
            }
        }
        BatchResult daoResult = this.batchProcessor.execute((HibernateOperation)new MergeOperation(), groupsToAdd);
        BatchResult batchResult = new BatchResult(groups.size());
        batchResult.addSuccesses((Collection)daoResult.getSuccessfulEntities());
        batchResult.addFailures((Collection)daoResult.getFailedEntities());
        batchResult.addFailures(groupsFailedValidation);
        return batchResult;
    }

    public BatchResultWithIdReferences<Group> addAll(Collection<InternalGroupWithAttributes> groups) {
        HashSet<TransactionGroup> groupsToAdd = new HashSet<TransactionGroup>();
        HashSet<InternalGroupWithAttributes> groupsFailedValidation = new HashSet<InternalGroupWithAttributes>();
        for (InternalGroupWithAttributes group : groups) {
            try {
                InternalGroup groupToAdd = group.getInternalGroup();
                HashSet<InternalGroupAttribute> attribs = new HashSet<InternalGroupAttribute>();
                for (String name : group.getKeys()) {
                    for (String val : group.getValues(name)) {
                        InternalGroupAttribute attrib = new InternalGroupAttribute(groupToAdd, name, val);
                        attribs.add(attrib);
                    }
                }
                groupsToAdd.add(new TransactionGroup((Serializable)groupToAdd, attribs));
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Could not add group <" + group.getName() + ">: " + e.getMessage());
                groupsFailedValidation.add(group);
            }
        }
        BatchResult daoResult = this.batchProcessor.execute((HibernateOperation)new MergeOperation(), groupsToAdd);
        BatchResultWithIdReferences result = new BatchResultWithIdReferences(groups.size());
        for (TransactionGroup transactionGroup : daoResult.getFailedEntities()) {
            result.addFailure((Object)transactionGroup.getPrimaryObject());
        }
        result.addFailures(groupsFailedValidation);
        for (TransactionGroup group : groupsToAdd) {
            result.addIdReference((InternalDirectoryEntity)group.getPrimaryObject());
        }
        return result;
    }

    public InternalGroup addLocal(Group group) throws DirectoryNotFoundException, InvalidGroupException {
        return this.add(group, true);
    }

    public InternalGroup findByName(long directoryId, String groupName) throws GroupNotFoundException {
        InternalGroup result = this.findByNameInternal(directoryId, groupName);
        if (result == null) {
            throw new GroupNotFoundException(groupName);
        }
        return result;
    }

    private InternalGroup findByNameInternal(long directoryId, String groupName) {
        return (InternalGroup)CriteriaFactory.createCriteria(this.session(), InternalGroup.class).add((Criterion)Restrictions.eq((String)"directory.id", (Object)directoryId)).add((Criterion)Restrictions.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)groupName))).uniqueResult();
    }

    public InternalGroupWithAttributes findByNameWithAttributes(long directoryId, String groupName) throws GroupNotFoundException {
        InternalGroup group = this.findByName(directoryId, groupName);
        Set<InternalGroupAttribute> attributesList = this.findGroupAttributes(group.getId());
        Map attributesMap = this.attributesHelper.attributesListToMap(attributesList);
        return new InternalGroupWithAttributes(group, attributesMap);
    }

    public Collection<InternalGroup> findByNames(long directoryID, Collection<String> groupnames) {
        return this.batchFinder.find(directoryID, groupnames, InternalGroup.class);
    }

    public Set<InternalGroupAttribute> findGroupAttributes(long groupId) {
        return Sets.newHashSet((Iterable)CriteriaFactory.createCriteria(this.session(), InternalGroupAttribute.class).add((Criterion)Restrictions.eq((String)"group.id", (Object)groupId)).list());
    }

    @Override
    public Class getPersistentClass() {
        return InternalGroup.class;
    }

    public void remove(Group group) throws GroupNotFoundException {
        InternalGroup groupToRemove = this.findByName(group.getDirectoryId(), group.getName());
        this.membershipDao.removeGroupMembers(group.getDirectoryId(), group.getName());
        this.membershipDao.removeGroupMemberships(group.getDirectoryId(), group.getName());
        this.session().getNamedQuery("removeAllInternalGroupAttributes").setEntity("group", (Object)groupToRemove).executeUpdate();
        super.remove(groupToRemove);
    }

    public void removeAll(long directoryId) {
        this.membershipDao.removeAllRelationships(directoryId);
        this.session().getNamedQuery("removeAllInternalGroupAttributesInDirectory").setLong("directoryId", directoryId).executeUpdate();
        this.session().getNamedQuery("removeAllGroupsInDirectory").setLong("directoryId", directoryId).executeUpdate();
    }

    public BatchResult<String> removeAllGroups(long directoryId, Set<String> groupNames) {
        Collection<InternalGroup> groups = this.findByNames(directoryId, groupNames);
        BatchResult batchResult = this.batchProcessor.execute((HibernateOperation)new RemoveGroupOperation(), groups);
        BatchResult overallResult = new BatchResult(groupNames.size());
        overallResult.addFailures(Collections2.transform((Collection)batchResult.getFailedEntities(), (Function)InternalEntityUtils.GET_NAME));
        overallResult.addSuccesses(Collections2.transform((Collection)batchResult.getSuccessfulEntities(), (Function)InternalEntityUtils.GET_NAME));
        return overallResult;
    }

    public void removeAttribute(Group group, String attributeName) throws GroupNotFoundException {
        this.removeAttributes(this.findByName(group.getDirectoryId(), group.getName()), attributeName);
    }

    public InternalGroup rename(Group group, String newName) throws GroupNotFoundException, InvalidGroupException {
        InternalGroup groupToRename = this.findByName(group.getDirectoryId(), group.getName());
        String oldName = groupToRename.getName();
        InternalGroup existingGroup = this.findByNameInternal(group.getDirectoryId(), newName);
        if (existingGroup != null) {
            throw new InvalidGroupException(group, "Cannot rename group as group with new name already exists: " + group.getName());
        }
        groupToRename.renameTo(newName);
        groupToRename.setUpdatedDateToNow();
        super.update(groupToRename);
        this.membershipDao.renameGroupRelationships(groupToRename.getDirectoryId(), oldName, groupToRename.getName());
        return groupToRename;
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.GROUP) {
            throw new IllegalArgumentException("GroupDAO can only evaluate EntityQueries for Entity.GROUP");
        }
        HQLQuery hqlQuery = this.hqlQueryTranslater.asHQL(directoryId, query);
        org.hibernate.Query hibernateQuery = this.createHibernateQuery((Query)query, hqlQuery);
        return HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
    }

    public void storeAttributes(Group group, Map<String, Set<String>> attributes) throws GroupNotFoundException {
        InternalGroupWithAttributes groupToUpdate = this.findByNameWithAttributes(group.getDirectoryId(), group.getName());
        for (String string : attributes.keySet()) {
            if (groupToUpdate.getValue(string) == null) continue;
            this.removeAttributes(groupToUpdate.getInternalGroup(), string);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            for (String value : (Set)entry.getValue()) {
                this.addAttribute(groupToUpdate.getInternalGroup(), (String)entry.getKey(), value);
            }
        }
    }

    public InternalGroup update(Group group) throws GroupNotFoundException {
        InternalGroup groupToUpdate = this.findByName(group.getDirectoryId(), group.getName());
        if (groupToUpdate.getType() != group.getType()) {
            throw new UnsupportedOperationException("Cannot modify the GroupType for an Internal group");
        }
        groupToUpdate.updateDetailsFrom(group);
        groupToUpdate.setUpdatedDateToNow();
        super.update(groupToUpdate);
        return groupToUpdate;
    }

    private InternalGroup add(Group group, boolean local) throws DirectoryNotFoundException, InvalidGroupException {
        InternalGroup existingGroup = this.findByNameInternal(group.getDirectoryId(), group.getName());
        if (existingGroup != null) {
            throw new InvalidGroupException(group, "Cannot add group as group with new name already exists: " + group.getName());
        }
        InternalGroup groupToAdd = new InternalGroup(group, this.getDirectory(group));
        groupToAdd.setLocal(local);
        groupToAdd.setCreatedDateToNow();
        groupToAdd.setUpdatedDateToNow();
        super.save(groupToAdd);
        return groupToAdd;
    }

    private void addAttribute(InternalGroup group, String attributeName, String attributeValue) {
        InternalGroupAttribute attribute = new InternalGroupAttribute(group, attributeName, attributeValue);
        this.session().save((Object)attribute);
        group.getAttributes().add(attribute);
    }

    private Directory getDirectory(Group group) throws DirectoryNotFoundException {
        Validate.notNull((Object)group.getDirectoryId(), (String)"Cannot add a group with null directoryId", (Object[])new Object[0]);
        return this.directoryDao.findById(group.getDirectoryId());
    }

    private void removeAttributes(InternalGroup group, String attributeName) {
        this.session().getNamedQuery("removeInternalGroupAttributes").setEntity("group", (Object)group).setString("attributeName", attributeName).executeUpdate();
    }

    @Autowired
    public void setAttributesHelper(InternalAttributesHelper attributesHelper) {
        this.attributesHelper = attributesHelper;
    }

    @Autowired
    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    @Autowired
    public void setMembershipDao(InternalMembershipDao membershipDao) {
        this.membershipDao = membershipDao;
    }
}

