/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.directory;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class DirectoryDAOHibernate
extends HibernateDao
implements DirectoryDao {
    private InternalGroupDao groupDao;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalUserDao userDao;

    public DirectoryImpl add(Directory directory) {
        DirectoryImpl directoryToPersist = new DirectoryImpl(directory);
        directoryToPersist.setCreatedDateToNow();
        directoryToPersist.setUpdatedDateToNow();
        directoryToPersist.validate();
        super.save(directoryToPersist);
        return directoryToPersist;
    }

    public List<Directory> findAll() {
        return this.session().createQuery("from DirectoryImpl").list();
    }

    public DirectoryImpl findById(long id) throws DirectoryNotFoundException {
        try {
            return (DirectoryImpl)this.load(id);
        }
        catch (ObjectNotFoundException e) {
            throw new DirectoryNotFoundException(Long.valueOf(id));
        }
    }

    public DirectoryImpl findByName(String name) throws DirectoryNotFoundException {
        Object result = CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)name))).uniqueResult();
        if (result == null) {
            throw new DirectoryNotFoundException(name);
        }
        return (DirectoryImpl)result;
    }

    @Override
    public Class getPersistentClass() {
        return DirectoryImpl.class;
    }

    public void remove(Directory directory) throws DirectoryNotFoundException {
        this.groupDao.removeAll(directory.getId().longValue());
        this.userDao.removeAll(directory.getId().longValue());
        super.remove(directory);
    }

    public List<Directory> search(EntityQuery query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.DIRECTORY) {
            throw new IllegalArgumentException("DirectoryDAO can only evaluate EntityQueries for Entity.DIRECTORY");
        }
        HQLQuery hqlQuery = this.hqlQueryTranslater.asHQL(query);
        org.hibernate.Query hibernateQuery = this.createHibernateQuery((Query)query, hqlQuery);
        return HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
    }

    public DirectoryImpl update(Directory directory) throws DirectoryNotFoundException {
        DirectoryImpl directoryToUpdate = this.findById(directory.getId());
        directoryToUpdate.setUpdatedDateToNow();
        directoryToUpdate.updateDetailsFrom(directory);
        directoryToUpdate.validate();
        super.update(directoryToUpdate);
        return directoryToUpdate;
    }

    @Autowired
    public void setGroupDao(InternalGroupDao groupDao) {
        this.groupDao = groupDao;
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    @Autowired
    public void setUserDao(InternalUserDao userDao) {
        this.userDao = userDao;
    }
}

