/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.application;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.alias.AliasDAO;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplicationDAOHibernate
extends HibernateDao
implements ApplicationDAO {
    private AliasDAO aliasDao;
    private DirectoryDao directoryDao;
    private HQLQueryTranslater hqlQueryTranslater;

    public ApplicationImpl add(Application application, PasswordCredential passwordCredential) {
        ApplicationImpl internalApplication = ApplicationImpl.newInstance((Application)application);
        internalApplication.setCredential(passwordCredential);
        internalApplication.setCreatedDateToNow();
        internalApplication.setUpdatedDateToNow();
        internalApplication.setAttribute("atlassian_sha1_applied", Boolean.TRUE.toString());
        internalApplication.validate();
        super.save(internalApplication);
        return internalApplication;
    }

    public void addDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate, OperationType ... operationTypes) throws DirectoryNotFoundException, ApplicationNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        Directory directory = this.directoryDao.findById(directoryId);
        application.addDirectoryMapping(directory, allowAllToAuthenticate, operationTypes);
        application.setUpdatedDateToNow();
        super.update(application);
    }

    public void addGroupMapping(long applicationId, long directoryId, String groupName) throws ApplicationNotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)groupName));
        ApplicationImpl application = this.findById(applicationId);
        application.addGroupMapping(directoryId, groupName);
        super.update(application);
    }

    public void addRemoteAddress(long applicationId, RemoteAddress remoteAddress) throws ApplicationNotFoundException {
        Validate.notNull((Object)remoteAddress);
        ApplicationImpl application = this.findById(applicationId);
        application.addRemoteAddress(remoteAddress.getAddress());
        application.setUpdatedDateToNow();
        super.update(application);
    }

    public List<Application> findAuthorisedApplications(long directoryId, List<String> groupNames) {
        if (groupNames == null || groupNames.isEmpty()) {
            return this.session().getNamedQuery("findAuthorisedApplicationsWithoutGroupNames").setLong("directoryId", directoryId).list();
        }
        return this.session().getNamedQuery("findAuthorisedApplications").setLong("directoryId", directoryId).setParameterList("groupNames", groupNames).list();
    }

    public ApplicationImpl findById(long id) throws ApplicationNotFoundException {
        try {
            return (ApplicationImpl)this.load(id);
        }
        catch (ObjectNotFoundException e) {
            throw new ApplicationNotFoundException(Long.valueOf(id));
        }
    }

    public ApplicationImpl findByName(String name) throws ApplicationNotFoundException {
        Object result = CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)name))).uniqueResult();
        if (result == null) {
            throw new ApplicationNotFoundException(name);
        }
        return (ApplicationImpl)result;
    }

    @Override
    public Class getPersistentClass() {
        return ApplicationImpl.class;
    }

    public void remove(Application application) {
        this.aliasDao.removeAliases(application);
        super.remove(application);
    }

    public void removeDirectoryMapping(long applicationId, long directoryId) throws ApplicationNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        application.removeDirectoryMapping(directoryId);
        application.setUpdatedDateToNow();
        super.update(application);
    }

    public void removeDirectoryMappings(long directoryId) {
        List applications = this.session().getNamedQuery("findApplicationsWithDirectoryMapping").setLong("directoryId", directoryId).list();
        for (ApplicationImpl application : applications) {
            application.removeDirectoryMapping(directoryId);
            application.setUpdatedDateToNow();
            super.update(application);
        }
    }

    public void removeGroupMapping(long applicationId, long directoryId, String groupName) throws ApplicationNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        application.getDirectoryMapping(directoryId).removeGroupMapping(groupName);
        super.update(application);
    }

    public void removeGroupMappings(long directoryId, String groupName) {
        this.session().getNamedQuery("removeAllGroupMappings").setLong("directoryId", directoryId).setString("groupName", groupName).executeUpdate();
    }

    public void removeRemoteAddress(long applicationId, RemoteAddress remoteAddress) throws ApplicationNotFoundException {
        Validate.notNull((Object)remoteAddress);
        ApplicationImpl application = this.findById(applicationId);
        application.removeRemoteAddress(remoteAddress.getAddress());
        super.update(application);
    }

    public void renameGroupMappings(long directoryId, String oldGroupName, String newGroupName) {
        this.session().getNamedQuery("renameGroupMappings").setLong("directoryId", directoryId).setString("oldGroupName", oldGroupName).setString("newGroupName", newGroupName).executeUpdate();
    }

    public List<Application> search(EntityQuery<Application> query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.APPLICATION) {
            throw new IllegalArgumentException("ApplicationDAO can only evaluate EntityQueries for Entity.APPLICATION");
        }
        HQLQuery hqlQuery = this.hqlQueryTranslater.asHQL(query);
        org.hibernate.Query hibernateQuery = this.createHibernateQuery((Query)query, hqlQuery);
        return HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
    }

    public ApplicationImpl update(Application application) throws ApplicationNotFoundException {
        ApplicationImpl internalApplication = this.findById(application.getId());
        internalApplication.updateDetailsFromApplication(application);
        internalApplication.setUpdatedDateToNow();
        internalApplication.validate();
        super.update(internalApplication);
        return internalApplication;
    }

    public void updateCredential(Application application, PasswordCredential passwordCredential) throws ApplicationNotFoundException {
        if (!passwordCredential.isEncryptedCredential()) {
            throw new IllegalArgumentException("The application password needs to be encrypted before being updated");
        }
        ApplicationImpl internalApplication = this.findByName(application.getName());
        internalApplication.setCredential(passwordCredential);
        internalApplication.setAttribute("atlassian_sha1_applied", Boolean.TRUE.toString());
        internalApplication.setUpdatedDateToNow();
        super.update(internalApplication);
    }

    public void updateDirectoryMapping(long applicationId, long directoryId, int position) throws ApplicationNotFoundException, DirectoryNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        List directoryMappings = application.getDirectoryMappings();
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping == null) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId));
        }
        int currentIndex = directoryMappings.indexOf(directoryMapping);
        if (currentIndex >= 0 && position >= 0 && position < directoryMappings.size()) {
            DirectoryMapping directoryMappingToMove = (DirectoryMapping)directoryMappings.remove(currentIndex);
            directoryMappings.add(position, directoryMappingToMove);
            application.setUpdatedDateToNow();
            super.update(application);
        }
    }

    public void updateDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate) throws ApplicationNotFoundException, DirectoryNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping == null) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId));
        }
        directoryMapping.setAllowAllToAuthenticate(allowAllToAuthenticate);
        application.setUpdatedDateToNow();
        super.update(application);
    }

    public void updateDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate, Set<OperationType> operationTypes) throws ApplicationNotFoundException, DirectoryNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping == null) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId));
        }
        directoryMapping.setAllowAllToAuthenticate(allowAllToAuthenticate);
        directoryMapping.setAllowedOperations(operationTypes);
        application.setUpdatedDateToNow();
        super.update(application);
    }

    @Autowired
    public void setAliasDao(AliasDAO aliasDao) {
        this.aliasDao = aliasDao;
    }

    @Autowired
    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }
}

