/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.alias;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.alias.AliasDAO;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.alias.Alias;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class AliasDAOHibernate
extends HibernateDao
implements AliasDAO {
    private HQLQueryTranslater hqlQueryTranslater;

    public String findAliasByUsername(Application application, String username) {
        Alias aliasObject = this.findAliasObjectByUsername(application, username);
        return aliasObject == null ? null : aliasObject.getAlias();
    }

    public List<Alias> findAll() {
        return CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).list();
    }

    public String findUsernameByAlias(Application application, String alias) {
        Alias aliasObject = this.findAliasObjectByAlias(application, alias);
        return aliasObject == null ? null : aliasObject.getName();
    }

    @Override
    public Class getPersistentClass() {
        return Alias.class;
    }

    public void removeAlias(Application application, String username) {
        Alias aliasObject = this.findAliasObjectByUsername(application, username);
        if (aliasObject != null) {
            this.remove(aliasObject);
        }
    }

    public void removeAliases(Application application) {
        this.session().getNamedQuery("removeAllAliasesForApplication").setEntity("application", (Object)application).executeUpdate();
    }

    public List<String> search(EntityQuery<String> entityQuery) {
        if (entityQuery.getEntityDescriptor().getEntityType() != Entity.ALIAS) {
            throw new IllegalArgumentException("AliasDAO can only evaluate EntityQueries for Entity.ALIAS");
        }
        HQLQuery hqlQuery = this.hqlQueryTranslater.asHQL(entityQuery);
        org.hibernate.Query hibernateQuery = this.createHibernateQuery((Query)entityQuery, hqlQuery);
        return HibernateSearchResultsTransformer.transformResults((List)hibernateQuery.list());
    }

    public void storeAlias(Application application, String username, String alias) {
        Validate.notNull((Object)application, (String)"Application cannot be null", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("Username cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)alias)) {
            throw new IllegalArgumentException("Alias cannot be blank");
        }
        Alias aliasObject = this.findAliasObjectByUsername(application, username);
        if (aliasObject != null) {
            aliasObject.setAlias(alias);
        } else {
            aliasObject = new Alias(application, username, alias);
        }
        this.saveOrUpdate(aliasObject);
    }

    public void removeAliasesForUser(String username) {
        this.session().getNamedQuery("removeAllAliasesForUser").setString("username", username).executeUpdate();
    }

    private Alias findAliasObjectByAlias(Application application, String alias) {
        return (Alias)CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"application", (Object)application)).add((Criterion)Restrictions.eq((String)"lowerAlias", (Object)IdentifierUtils.toLowerCase((String)alias))).uniqueResult();
    }

    private Alias findAliasObjectByUsername(Application application, String username) {
        return (Alias)CriteriaFactory.createCriteria(this.session(), this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"application", (Object)application)).add((Criterion)Restrictions.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)username))).uniqueResult();
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }
}

