/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletURIResolver
implements URIResolver {
    private Log log = LogFactory.getLog(this.getClass());
    static final String protocol = "res:";
    private ServletContext sc;

    public ServletURIResolver(ServletContext sc) {
        this.log.trace((Object)("ServletURIResolver: " + sc));
        this.sc = sc;
    }

    public Source resolve(String href, String base) throws TransformerException {
        this.log.debug((Object)("ServletURIResolver resolve(): href=" + href + ", base=" + base));
        if (href.startsWith(protocol)) {
            String res = href.substring(protocol.length());
            this.log.debug((Object)("Resolving resource <" + res + ">"));
            InputStream is = this.sc.getResourceAsStream(res);
            if (is == null) {
                throw new TransformerException("Resource " + res + " not found in resources.");
            }
            return new StreamSource(is);
        }
        throw new TransformerException("Cannot handle procotol of resource " + href);
    }
}

