/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.util;

import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.components.Form;
import com.opensymphony.xwork.util.OgnlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityUtil {
    public static final String OGNL_UNSAFE = "OgnlUnsafe";

    private SecurityUtil() {
    }

    public static Map<String, Object> getUnescapedParameters(Log log, Component bean, Map<String, Object> parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap<String, Object> unescapedParameters = parameters instanceof HashMap ? new HashMap() : new TreeMap();
        for (Map.Entry<String, Object> keyValue : parameters.entrySet()) {
            String key = keyValue.getKey();
            if (key.endsWith(OGNL_UNSAFE)) continue;
            Object escapedOrOveriddenValue = keyValue.getValue();
            Object originalValueBeforeEscaping = SecurityUtil.getUnescapedValue(parameters, key);
            if (originalValueBeforeEscaping instanceof String) {
                boolean knownOverridingTag;
                String reescapedValue = SecurityUtil.wrapAsOgnlExpression(OgnlUtil.escapeLiteral((String)((String)originalValueBeforeEscaping)).toString());
                if (reescapedValue.equals(escapedOrOveriddenValue)) {
                    unescapedParameters.put(key, originalValueBeforeEscaping);
                    continue;
                }
                unescapedParameters.put(key, escapedOrOveriddenValue);
                boolean isPlainOgnlEvaluation = originalValueBeforeEscaping.equals(escapedOrOveriddenValue);
                if (log == null || isPlainOgnlEvaluation || (knownOverridingTag = bean instanceof Form)) continue;
                String beanName = bean != null ? bean.getClass().getCanonicalName() : "unknown";
                log.debug((Object)(key + " was overridden from " + reescapedValue + " to " + escapedOrOveriddenValue + " by " + beanName));
                continue;
            }
            unescapedParameters.put(key, escapedOrOveriddenValue);
        }
        return unescapedParameters;
    }

    public static String wrapAsOgnlExpression(String expr) {
        return "%{" + expr + "}";
    }

    public static boolean hasUnescapedValue(Map parameters, String name) {
        return parameters.containsKey(SecurityUtil.getNameOfUnEscapedParameter(name));
    }

    private static Object getUnescapedValue(Map<String, Object> parameters, String name) {
        return parameters.get(SecurityUtil.getNameOfUnEscapedParameter(name));
    }

    private static String getNameOfUnEscapedParameter(String name) {
        return name + OGNL_UNSAFE;
    }
}

