/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHttpHeaderPopulatingResult
extends WebWorkResultSupport {
    private static final Log LOG = LogFactory.getLog(AbstractHttpHeaderPopulatingResult.class);
    private Map headers;

    public Map getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        return this.headers;
    }

    public void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        if (this.headers != null) {
            OgnlValueStack stack = ActionContext.getContext().getValueStack();
            for (Map.Entry entry : this.headers.entrySet()) {
                String value = (String)entry.getValue();
                String finalValue = this.conditionalParse(value, invocation);
                response.addHeader((String)entry.getKey(), finalValue);
            }
            if (LOG.isDebugEnabled()) {
                if (!this.headers.isEmpty()) {
                    String log_statement = "populated HttpServletRespons's Header with";
                    for (Map.Entry entry : this.headers.entrySet()) {
                        log_statement = log_statement + "\n\t" + entry.getKey() + "=" + entry.getValue();
                    }
                    LOG.debug((Object)log_statement);
                } else {
                    LOG.debug((Object)"Nothing was populated to HttpServletResponse's header");
                }
            }
        }
        this.afterHttpHeadersPopulatedExecute(finalLocation, invocation);
    }

    protected abstract void afterHttpHeadersPopulatedExecute(String var1, ActionInvocation var2) throws Exception;
}

